<?php
$page = (!empty($input_get['page-id'])) ? $input_get['page-id'] : 1;
$filter_keyword = (!empty($input_get['query'])) ? ($input_get['query']) : '';
$filter_type = '';
$db->pageLimit = 20;
if (empty($linkto[3])) {
    $index = 'index';
} else {
    $index = $linkto[3];
}
if (!empty($filter_keyword)) {
    $sql = " {$filter_type} (order_link LIKE '%$filter_keyword%' OR order_name LIKE '%$filter_keyword%' OR order_status LIKE '%$filter_keyword%' OR order_id_ordem_api LIKE '%$filter_keyword%' OR order_category LIKE '%$filter_keyword%' OR order_type LIKE '%$filter_keyword%' OR order_username LIKE '%$filter_keyword%') ";
    $list_ordens = $db->where($sql)->orderBy('order_id', 'DESC')->objectbuilder()->paginate('ws_ordens', $page);
} else {
    $list_ordens = $db->objectbuilder()->orderBy('order_id', 'desc')->paginate('ws_ordens', $page);
}
$count = count($db->get('ws_ordens'));
if (($page > $db->totalPages) && !empty($input_get['page-id'])) {
    header("Location: " . BASE . $_SERVER['REQUEST_URI']);
    exit();
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section id="basic-form-layouts">
            <!-- Main content -->
            <div class="row">
                <!-- right column -->
                <div class="col-md-12">

                    <form action='<?= ADMIN; ?>/<?= $linkto[2]; ?>/index' method='get'>
                        <div class="row">
                            <div class="col-lg-2 pull-right">
                                <a class="btn btn-info" href="<?= ADMIN; ?>/<?= $linkto[2]; ?>/inserir"><i class='fa fa-plus-circle'></i> Adicionar</a>
                            </div>
                            <div class="col-lg-10 pull-right">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Pesquisar por nome, link, ID API, serviço, status, tipo e etc" name='query' id='query'>
                                    <span class="input-group-btn">
                                        <button class="btn btn-info" type="submit"><i class='fa fa-search'></i></button>
                                    </span>
                                </div><!-- /input-group -->
                            </div><!-- /.col-lg-6 -->
                        </div>
                    </form>

                </div>
            </div>
            <div class="row">
                <!-- right column -->
                <!-- right column -->
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Listar ordens</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body table-responsive">
                                <table class="table text-center">
                                    <thead>
                                        <tr>
                                            <th scope="col">Nº</th>
                                            <th scope="col">API Ordem ID</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Usuário</th>
                                            <th scope="col">Link</th>
                                            <th scope="col">Quantidade</th>
                                            <th scope="col">Inicial</th>
                                            <th scope="col">Final</th>
                                            <th scope="col">Serviço</th>
                                            <th scope="col">Tipo</th>
                                            <th scope="col">Data</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if ($list_ordens) {
                                            foreach ($list_ordens as $key => $ordens) {
                                                $usuario = $db->where('user_id', $ordens->order_user_id)->getOne('ws_users');
                                                if ($usuario) {
                                                    $update = $db->where('order_user_id', $ordens->order_user_id)->update("ws_ordens", array('order_username' => $usuario->user_name));
                                                } else {
                                                    $update = $db->where('order_id', $ordens->order_id)->update("ws_ordens", array('order_username' => $usuario->user_name));
                                                }
                                                if (empty($ordens->order_id_ordem_api) && $ordens->order_id_ordem_api == null) {
                                                    $botao = '<a href="javascript:;" class="btn btn-sm btn-primary btn_order_' . $ordens->order_id . '" onclick="enviarApi(' . $ordens->order_id . ');">Enviar</a>';
                                                    $btn_sts = $ordens->order_status;
                                                } else {
                                                    $botao = $ordens->order_id_ordem_api;
                                                    $btn_sts = '<a href="javascript:;" class="btn btn-sm btn-info btn_status_' . $ordens->order_id . '" onclick="updateStatus(' . $ordens->order_id_ordem_api . ',' . $ordens->order_id_api . ',' . $ordens->order_id . ');">' . $ordens->order_status . '</a>';
                                                }
                                                ?>
                                                <tr>
                                                    <td><?= $ordens->order_id; ?></td>
                                                    <td>
                                                        <?= $botao; ?>
                                                    </td>
                                                    <td>
                                                        <?= $btn_sts; ?>
                                                    </td>
                                                    <td><?= $ordens->order_username; ?></td>
                                                    <td><?= $ordens->order_link; ?></td>
                                                    <td><?= $ordens->order_quantidade; ?></td>
                                                    <td><?= $ordens->order_qtd_inicial; ?></td>
                                                    <td><?= $ordens->order_qtd_final; ?></td>
                                                    <td><?= $ordens->order_name; ?></td>
                                                    <td><?= $ordens->order_type; ?></td>
                                                    <td><?= date('d/m/Y', strtotime($ordens->created_at)); ?></td>

                                                </tr>   
                                                <?php
                                            }
                                        }
                                        ?>                                
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="col-md-6 pull-left">
                        <?php echo "Total (" . $count . ") registros | Mostrando $page página(s) de " . $db->totalPages; ?>
                    </div>
                    <div class="col-md-6 pull-right">
                        <nav class="" aria-label="Page navigation mb-3">
                            <ul class="pagination justify-content-end">
                                <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=1" aria-label="Previous"><i class="fa fa-home"></i></a>
                                </li>
                                <?php if ($page > 1) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page - 1); ?>"><i class="fa fa-chevron-left"></i></a></li>
                                <?php } ?>
                                <?php
                                $nums = 0;
                                $nums_pages = ($page > 4) ? ($page - 4) : $page;
                                for ($i = $nums_pages; $i <= $db->totalPages; $i++) {
                                    if ($nums < 20) {
                                        ?>
                                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($i); ?>"><?php echo $i ?></a></li>
                                        <?php
                                    }
                                    $nums++;
                                }
                                ?>
                                <?php if ($db->totalPages > $page) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page + 1); ?>"><i class="fa fa-chevron-right"></i></a></li>
                                <?php } ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($db->totalPages); ?>" aria-label="Next"><i class="fa fa-forward"></i></a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
        </section>       
        <!-- /.box -->
    </div>
    <!--/.col (right) -->
</div>
<!-- /.row -->

<!-- /.content -->
</div>
</div>
<div class="modal fade text-left" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel10" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content modal-col-red">
            <div class="modal-header bg-danger white">
                <h4 class="modal-title" id="myModalLabel10">DELETAR REGISTRO</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja remover esse registro?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger waves-effect delete-button" data-dismiss="modal" data-type="<?= $linkto[2]; ?>">DELETAR</button>
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">FECHAR</button>
            </div>
        </div>
    </div>
</div>