<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/conecta.php';

global $db, $mysqli, $pt;

$reference_code = time();
$order = 0;

define("MAX_SIZE", "9000");

function getExtension($str) {
    $i = strrpos($str, ".");
    if (!$i) {
        return "";
    }
    $l = strlen($str) - $i;
    $ext = substr($str, $i + 1, $l);
    return $ext;
}

$valid_formats = array("jpg", "png", "gif", "bmp", "jpeg");

function limpaCPF_CNPJ($valor) {
    $valor = trim($valor);
    $valor = str_replace(",", ".", $valor);
    $valor = str_replace("_", "", $valor);
    $valor = str_replace("/", "", $valor);
    $valor = str_replace("(", "", $valor);
    $valor = str_replace(")", "", $valor);
    $valor = str_replace(" ", "", $valor);
    return $valor;
}

$idCat = null;
$category_id = null;
if (isset($_SESSION['userloginAdmin'])) {

    if (isset($input_post['action']) && $input_post['action'] == 'post_create') {
//        $category_title = $input_post['category_title'];
        if (isset($input_post['idCat'])) {
            $idCat = (int) $input_post['idCat'];
        }
        if (isset($input_post['category_id'])) {
            $category_id = $input_post['category_id'];
            unset($input_post['category_id']);
        }
        unset($input_post['action'], $_FILES['files'], $input_post['category_title']);

        if (isset($input_post['post_type']) && $input_post['post_type'] == 'banners') {
            $width = $pt->config->upload_image_width_banner;
            $height = $pt->config->upload_image_height_banner;
        } elseif (isset($input_post['post_type']) && $input_post['post_type'] == 'pages') {
            $width = 1200;
            $height = null;
        } else {
            $width = $pt->config->upload_image_width;
            $height = $pt->config->upload_image_height;
            if (isset($input_post['post_category'])) {
                $input['post_category'] = $input_post['post_category'];
            }
        }

        $input_post['post_date'] = date('Y-m-d H:i:s');
        $input_post['post_update'] = date('Y-m-d H:i:s');
        $input_post['post_views'] = 0;
        $input_post['post_last_views'] = date('Y-m-d H:i:s');
        unset($input_post['post_category']);
        $insert = $db->insert('ws_posts', $input_post);

        if (isset($input_post['post_ordem'])) {
            $order = $input_post['post_ordem'];
        } else {
            $order = 0;
        }
        if ($input_post['post_type'] == 'posts') {
            if (isset($input['post_category'])):
                $relationships = ws_term_relationships($input['post_category'], $insert, $order);
            endif;
        }
        if ($input_post['post_type'] == 'produtos') {
            if (isset($input['post_category'])):
                $relationships = ws_term_relationships($input['post_category'], $insert, $order);
            endif;
        }
        if ($input_post['post_type'] == 'arquivos') {
            if (isset($category_id)):

                $read = new Read();
                $update = new Update();
                $create = new Create();
                $cad['object_id'] = $insert;
                $cad['term_order'] = $order;
                $cad['term_taxonomy_id'] = $category_id;

                $read->ExeRead("ws_term_relationships", "where object_id = :post and term_taxonomy_id = :catid", "post={$insert}&catid={$category_id}");
                if ($read->getResult()):
                    $update->ExeUpdate("ws_term_relationships", $cad, "where object_id = :post and term_taxonomy_id = :catid", "post={$insert}&catid={$category_id}");
                    if ($update->getResult()):
                    endif;
                else:
                    $create->ExeCreate("ws_term_relationships", $cad);
                    if ($create->getResult()):
                    endif;
                endif;
                $read->ExeRead("ws_term_relationships", "where term_taxonomy_id = :catid", "catid={$category_id}");
                $update->ExeUpdate("ws_term_taxonomy", array('count' => count($read->getResult())), "where term_id = :catid", "catid={$category_id}");
            endif;
        }
        if ($insert) {
            echo json_encode(['status' => 200, 'type' => $input_post['post_type'], 'idCat' => $category_id, 'id' => $insert, 'code' => 'success', 'msg' => 'Informações registradas com sucesso!']);
        } else {
            echo json_encode(['status' => 400, 'code' => 'danger', 'msg' => 'Erro ao tentar enviar informações!']);
        }
    }
    if (isset($input_post['action']) && $input_post['action'] == 'post_update') {
        $id = (int) $input_post['id'];
        if (isset($input_post['idCat'])) {
            $idCat = (int) $input_post['idCat'];
        }
        unset($input_post['action'], $input_post['id'], $input_post['idCat']);
        if (isset($input_post['category_id'])) {
            $category_id = $input_post['category_id'];
            unset($input_post['category_id']);
        }
        unset($input_post['category_title']);

        if (!isset($input_post['post_api'])) {
            $input_post['post_api'] = null;
        }
        $post = $db->where('post_id', $id)->getOne('ws_posts');

        if (isset($input_post['post_type']) && $input_post['post_type'] == 'banners') {
            $width = $pt->config->upload_image_width_banner;
            $height = $pt->config->upload_image_height_banner;
        } elseif (isset($input_post['post_type']) && $input_post['post_type'] == 'pages') {
            $width = 1200;
            $height = null;
        } else {
            $width = $pt->config->upload_image_width;
            $height = $pt->config->upload_image_height;
            if (isset($input_post['post_category'])) {
                $input['post_category'] = $input_post['post_category'];
            }
        }
        if (isset($input_post['post_update'])) {
            $input_post['post_update'] = $check->Data($input_post['post_update']);
        } else {
            $input_post['post_update'] = date('Y-m-d H:i:s');
        }
        if (isset($input_post['post_ordem'])) {
            $order = $input_post['post_ordem'];
        }

        if ($input_post['post_type'] == 'arquivos') {
            unset($input_post['post_category']);
            if (isset($category_id)):

                $read = new Read();
                $update = new Update();
                $create = new Create();
                $cad['object_id'] = $id;
                $cad['term_order'] = $order;
                $cad['term_taxonomy_id'] = $category_id;

                $read->ExeRead("ws_term_relationships", "where object_id = :post and term_taxonomy_id = :catid", "post={$id}&catid={$category_id}");
                if ($read->getResult()):
                    $update->ExeUpdate("ws_term_relationships", $cad, "where object_id = :post and term_taxonomy_id = :catid", "post={$id}&catid={$category_id}");
                    if ($update->getResult()):
                    endif;
                else:
                    $create->ExeCreate("ws_term_relationships", $cad);
                    if ($create->getResult()):
                    endif;
                endif;
                $read->ExeRead("ws_term_relationships", "where term_taxonomy_id = :catid", "catid={$category_id}");
                $update->ExeUpdate("ws_term_taxonomy", array('count' => count($read->getResult())), "where term_id = :catid", "catid={$category_id}");
            endif;
        }
        if ($input_post['post_type'] == 'posts') {
            unset($input_post['post_category']);
            if (isset($input['post_category'])):
                $relationships = ws_term_relationships($input['post_category'], $id, $order);
            endif;
        }
        if ($input_post['post_type'] == 'produtos') {
            unset($input_post['post_category']);
            if (isset($input['post_category'])):
                $relationships = ws_term_relationships($input['post_category'], $id, $order);
            endif;
        }
        if ($input_post['post_type'] == 'projetos') {
            unset($input_post['post_category']);
            if (isset($input['post_category'])):
                $relationships = ws_term_relationships($input['post_category'], $id, $order);
            endif;
        }


        if (!empty($_FILES['post_cover']['tmp_name'])) {

            $uploaddir = "uploads/";
            $file_upload['filename'] = '';

            $filename = stripslashes($_FILES['post_cover']['name']);

            $size = filesize($_FILES['post_cover']['tmp_name']);

            $ext = getExtension($filename);
            $ext = strtolower($ext);

            if (in_array($ext, $valid_formats)) {

                if ($size < (MAX_SIZE * 1024)) {

                    $image_name = time() . $filename;

                    $newname = $uploaddir . $image_name;

                    if (move_uploaded_file($_FILES['post_cover']['tmp_name'], $_SERVER['DOCUMENT_ROOT'] . '/' . $newname)) {

                        $file_upload['filename'] = $uploaddir . $image_name;
                    } else {
                        echo '<span class="imgList">Ficheiro não foi carregado!</span>';
                    }
                } else {
                    echo '<span class="imgList">Limite de tamanho atingido!</span>';
                }
            } else {
                echo '<span class="imgList">Extensão do ficheiro desconhecida!</span>';
            }
        }
        if (!empty($file_upload['filename'])) {
            $input_post['post_cover'] = PT_Secure($file_upload['filename'], 0);
        }

        $arrays = [
            "post_title" => $input_post['post_title'],
            "post_name" => $input_post['post_name'],
            "post_subtitle" => $input_post['post_subtitle'] = isset($input_post['post_subtitle']) ? $input_post['post_subtitle'] : null,
            "post_subtitleDois" => $input_post['post_subtitleDois'] = isset($input_post['post_subtitleDois']) ? $input_post['post_subtitleDois'] : null,
            "post_subtitleTres" => $input_post['post_subtitleTres'] = isset($input_post['post_subtitleTres']) ? $input_post['post_subtitleTres'] : null,
            "post_subtitleQuatro" => $input_post['post_subtitleQuatro'] = isset($input_post['post_subtitleQuatro']) ? $input_post['post_subtitleQuatro'] : null,
            "post_subtitleCinco" => $input_post['post_subtitleCinco'] = isset($input_post['post_subtitleCinco']) ? $input_post['post_subtitleCinco'] : null,
            "post_subtitleSeis" => $input_post['post_subtitleSeis'] = isset($input_post['post_subtitleSeis']) ? $input_post['post_subtitleSeis'] : null,
            "post_subtitleSete" => $input_post['post_subtitleSete'] = isset($input_post['post_subtitleSete']) ? $input_post['post_subtitleSete'] : null,
            "post_subtitleOito" => $input_post['post_subtitleOito'] = isset($input_post['post_subtitleOito']) ? $input_post['post_subtitleOito'] : null,
            "post_subtitleNove" => $input_post['post_subtitleNove'] = isset($input_post['post_subtitleNove']) ? $input_post['post_subtitleNove'] : null,
            "post_subtitleDez" => $input_post['post_subtitleDez'] = isset($input_post['post_subtitleDez']) ? $input_post['post_subtitleDez'] : null,
            "post_token" => $input_post['post_token'] = isset($input_post['post_token']) ? $input_post['post_token'] : null,
            "post_content" => $input_post['post_content'],
            "post_type" => $input_post['post_type'],
            "post_status" => $input_post['post_status'],
            "post_update" => $input_post['post_update'],
            "post_author" => $input_post['post_author'],
            "post_membro_id" => $input_post['post_membro_id'] = isset($input_post['post_membro_id']) ? $input_post['post_membro_id'] : 0,
        ];
        if (isset($input_post['post_cover'])) {
            $arrays['post_cover'] = $input_post['post_cover'];
        }
        
        $update = $db->where('post_id', $id)->update('ws_posts', $arrays);

        if ($update) {
            echo json_encode(['status' => 200, 'type' => $input_post['post_type'], 'idCat' => $idCat, 'id' => $id, 'code' => 'success', 'msg' => 'Informações atualizadas com sucesso!']);
        } else {
            echo json_encode(['status' => 400, 'code' => 'danger', 'msg' => 'Erro ao tentar atualizar informações!']);
        }
    }

    if (isset($input_post['action']) && $input_post['action'] == 'post_update_legenda_gallery') {
        if (isset($input_post['id']) && isset($input_post['legenda'])) {
            $id = (int) $input_post['id'];
            $dados = array(
                'legenda' => $input_post['legenda'],
            );
            $update = $db->where('gallery_id', $id)->update('ws_posts_gallery', $dados);
        }
    }
    if (isset($input_post['action']) && $input_post['action'] == 'post_update_ordem_gallery') {
        if (isset($input_post['id']) && isset($input_post['ordem'])) {
            $id = (int) $input_post['id'];
            $dados = array(
                'ordem' => $input_post['ordem'],
            );
            $update = $db->where('gallery_id', $id)->update('ws_posts_gallery', $dados);
        }
    }

    if (isset($input_post['action']) && $input_post['action'] == 'filtrar_galeria') {
        $arr = [];
        $listar = $db->where('post_id', $input_post['post_id'])->orWhere("legenda", $input_post['search'] . '%', 'like')->orWhere("gallery_image", $input_post['search'] . '%', 'like')->get('ws_posts_gallery');
        if ($listar) {
            foreach ($listar as $array) {
                $array = (array) $array;
                $arr[] = $array;
            }
            exit(json_encode($arr, JSON_PRETTY_PRINT));
        }
    }
    if (isset($input_post['action']) && $input_post['action'] == 'links_externos') {
        $list = $db->where('post_id', $input_post['id'])->getOne('ws_posts');
        if ($list) {
            echo json_encode($list);
        }
    }
    if (isset($input_post['action']) && $input_post['action'] == 'list_arquivos') {
        $arr = [];
        $listar = $db->where('term_taxonomy_id', $input_post['id'])->get('ws_term_relationships');
        if ($listar) {

            foreach ($listar as $arrays) {
                $array = $db->where('post_id', $arrays->object_id)->getOne('ws_posts');
                $pasta = $db->where('term_id', $arrays->term_taxonomy_id)->getOne('ws_terms');
                if ($array) {
                    $author = $db->where('user_id', $array->post_author)->getOne('ws_users');
                    $array->user_name = $author->user_name;
                    $array->pasta = $pasta->name;
                    $array->action = '<a href="' . ADMIN . '/' . $array->post_type . '/ver/' . $array->post_id . '" class="btn btn-md btn-success"><i class="fa fa-eye"></i></a>';
                    $array->post_update = date('d/m/Y', strtotime($array->post_update));
                    $array->post_status = ($array->post_status == 1) ? '<span class="label label-success">Ativo</span>' : '<span class="label label-danger">Inativo</span>';
                    $array = (array) $array;
                    $arr[] = $array;
                }
            }
            exit(json_encode($arr, JSON_PRETTY_PRINT));
        } else {
            exit(json_encode(array('mensagem' => 'Erro ao tentar listar, tente novamente')));
        }
    }
}