<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Banner
 *
 * @author WEBLAB
 */
class Banner {

    private $Data;
    private $Banner;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'ga_banners';

    /**
     * <b>Cadastrar a Empresa:</b> Envelope os dados da empresa em um array atribuitivo e execute esse método
     * para cadastrar a mesma no banco.
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;
        
            $this->setData();
            $this->setName();
            if ($this->Data['Banner']):
            $uplaod = new Upload;
            $uplaod->Image($this->Data['Banner'], $this->Data['BannerSlug'], 940, 'banners', $this->Data['Banner']['size']);
        endif;

        if (isset($uplaod) && $uplaod->getResult()):
            $this->Data['Banner'] = $uplaod->getResult();
            $this->Create();
        else:
            $this->Data['Banner'] = null;
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar a Empresa:</b> Envelope os dados em uma array atribuitivo e informe o id de uma empresa
     * para atualiza-la no banco de dados!
     * @param INT $EmpresaId = Id da Empresa
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($BannerId, array $Data) {
        $this->Banner = (int) $BannerId;
        $this->Data = $Data;
        
            $this->setData();
            $this->setName();
            if (is_array($this->Data['Banner'])):
            $readCapa = new Read;
            $readCapa->ExeRead(self::Entity, "WHERE idBanner = :post", "post={$this->Banner}");
            $capa = '../uploads/' . $readCapa->getResult()[0]->Banner;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;

            $uploadCapa = new Upload;
            $uploadCapa->Image($this->Data['Banner'], $this->Data['BannerSlug'], 940, 'banners', $this->Data['Banner']['size']);
        endif;

        if (isset($uploadCapa) && $uploadCapa->getResult()):
            $this->Data['Banner'] = $uploadCapa->getResult();
            $this->Update();
        else:
            unset($this->Data['Banner']);
            $this->Update();
        endif;
    }

    /**
     * <b>Deleta Empresas:</b> Informe o ID da empresa a ser removida para que esse método realize uma
     * checagem excluinto todos os dados nessesários e removendo a empresa do banco!
     * @param INT $EmpresaId = Id da empresa!
     */
    public function ExeDelete($BannerId) {
        $this->Banner = (int) $BannerId;

        $ReadEmp = new Read;
        $ReadEmp->ExeRead(self::Entity, "WHERE idBanner = :id", "id={$this->Banner}");
        
        if (!$ReadEmp->getResult()):
            $this->Error = ["O Banner que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else:
            $EmpDelete = $ReadEmp->getResult()[0];
            if (file_exists('../uploads/' . $EmpDelete->Banner) && !is_dir('../uploads/' . $EmpDelete->Banner)):
                unlink('../uploads/' . $EmpDelete->Banner);
            endif;

            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE idBanner = :id", "id={$this->Banner}");

            $this->Error = ["O Banner <b>{$EmpDelete->BannerTitulo}</b> foi removido com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    /**
     * <b>Ativa/Inativa Empresa:</b> Informe o ID da empresa e o status e um status sendo 1 para ativo e 0 para
     * rascunho. Esse méto ativa e inativa as empresas!
     * @param INT $PostId = Id do post
     * @param STRING $PostStatus = 1 para ativo, 0 para inativo
     */
    public function ExeStatus($BannerId, $BannerStatus) {
        $this->Banner = (int) $BannerId;
        $this->Data['BannerStatus'] = (string) $BannerStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE idBanner = :id", "id={$this->Banner}");
    }

    /**
     * <b>Verificar Ação:</b> Retorna TRUE se ação for efetuada ou FALSE se não. Para verificar erros
     * execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com um erro e um tipo.
     * @return ARRAY $Error = Array associativo com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro. Realiza Upload da Capa!
    private function setData() {
        $check = new Check;
        $this->Data['BannerSlug'] = $check->Name($this->Data['BannerTitulo']);
        $this->Data['BannerData'] = date('Y-m-d H:i:s');
    }

    //Verifica o NAME da empresa. Se existir adiciona um pós-fix +1
    private function setName() {
        $Where = ( isset($this->Banner) ? "idBanner != {$this->Banner} AND" : '');

        $ReadName = new Read;
        $ReadName->ExeRead(self::Entity, "WHERE {$Where} BannerTitulo = :t", "t={$this->Data['BannerTitulo']}");
        if ($ReadName->getResult()):
            $this->Data['BannerSlug'] = $this->Data['BannerSlug'] . '-' . $ReadName->getRowCount();
        endif;
    }

    //Verifica e envia a capa da empresa para a pasta!
    private function sendCapa() {
        if (!empty($this->Data['Banner']['tmp_name'])):
            list($w, $h) = getimagesize($this->Data['Banner']['tmp_name']);

            if ($w > '2000' || $h > '700'):
                $this->Error = ['Banner Inválido: O Banner deve ter no mínimo 2000x700px do tipo .JPG, .PNG ou .GIF!', WS_INFOR];
                $this->Result = false;
            else:
                $this->checkCover();
                $Upload = new Upload;
                $Upload->Image($this->Data['Banner'], $this->Data['BannerSlug'], 940, 'banners');

                if ($Upload->getError()):
                    $this->Error = $Upload->getError();
                    $this->Result = false;
                else:
                    $this->Data['Banner'] = $Upload->getResult();
                    $this->Result = true;
                endif;
            endif;
        endif;
    }

    //Verifica se já existe uma capa, se sim deleta para enviar outra!
    private function checkCover() {
        $readCapa = new Read;
        $readCapa->FullRead("SELECT Banner FROM ga_banners WHERE idBanner = :id", "id={$this->Banner}");

        if ($readCapa->getRowCount()):
            $delCapa = $readCapa->getResult()[0]['Banner'];
            if (file_exists("../uploads/{$delCapa}") && !is_dir("../uploads/{$delCapa}")):
                unlink("../uploads/{$delCapa}");
            endif;
        endif;
    }

    //Cadastra a empresa no banco!
    private function Create() {
        $Create = new Create;
        $Create->ExeCreate(self::Entity, $this->Data);
        if ($Create->getResult()):
            $this->Result = $Create->getResult();
            $this->Error = ["O Banner <b>{$this->Data['BannerTitulo']}</b> foi cadastrado com sucesso no sistema!", WS_ACCEPT];
        endif;
    }

    //Atualiza a empresa no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE idBanner = :id", "id={$this->Banner}");
        if ($Update->getRowCount() >= 1):
            $this->Error = ["O Banner <b>{$this->Data['BannerTitulo']}</b> foi atualizado com sucesso!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
