<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of AdminMidias
 *
 * @author Agência Web Lab
 */
class AdminMidias {

    private $Data;
    private $Post;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'ws_midias';
    
    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        if (is_array($this->Data['midia_file'])):
            $readCapa = new Read;
            $readCapa->ExeRead(self::Entity, "WHERE midia_id = :post", "post={$this->Post}");
            $capa = $_SERVER['DOCUMENT_ROOT'].'/uploads/' . $readCapa->getResult()[0]->midia_file;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;

            $uploadCapa = new Upload;
            $uploadCapa->Image($this->Data['midia_file']);
        endif;

        if (isset($uploadCapa) && $uploadCapa->getResult()):
            $this->Data['midia_file'] = $uploadCapa->getResult();
            $this->Update();
        else:
            unset($this->Data['midia_file']);
            $this->Update();
        endif;
        
        
    }

    public function gbSendImagem(array $Images, $autor) {

        $this->Data = $Images;

        $gbFiles = array();
        $gbCount = count($this->Data['tmp_name']);
        $gbKeys = array_keys($this->Data);

        for ($gb = 0; $gb < $gbCount; $gb++):
            foreach ($gbKeys as $Keys):
                $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
            endforeach;
        endfor;

        $gbSend = new Upload;
        $i = 0;
        $u = 0;

        foreach ($gbFiles as $gbUpload):
            $i++;
            $ImageName = $gbUpload['name'];
            $ImgName = "{$ImageName}-gb-" . (substr(md5(time() + $i), 0, 8));

            $gbSend->Image($gbUpload, $ImgName);

            if ($gbSend->getResult()):
                $gbImage = $gbSend->getResult();
                $gbCreate = ["midia_file" => $gbImage, "midia_author" => $autor, "midia_type" => 'image', "midia_date" => date('Y-m-d H:i:s'),"midia_status"=>1];
                $insertGb = new Create;
                $insertGb->ExeCreate("ws_midias", $gbCreate);
                $u++;
            endif;
        endforeach;

        if ($u >= 1):
            $this->Error = ["Mídia Atualizada: Foram enviadas <b>{$u}</b> imagens para biblioteca!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    public function gbSendFile(array $Images, $autor) {

        $this->Data = $Images;

        $gbFiles = array();
        $gbCount = count($this->Data['tmp_name']);
        $gbKeys = array_keys($this->Data);

        for ($gb = 0; $gb < $gbCount; $gb++):
            foreach ($gbKeys as $Keys):
                $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
            endforeach;
        endfor;

        $gbSend = new Upload;
        $i = 0;
        $u = 0;

        foreach ($gbFiles as $gbUpload):
            $i++;
            $ImageName = $gbUpload['name'];
            $ImgName = "{$ImageName}-gb-" . (substr(md5(time() + $i), 0, 8));

            $gbSend->File($gbUpload, $ImgName);

            if ($gbSend->getResult()):
                $gbImage = $gbSend->getResult();
                $gbCreate = ["midia_file" => $gbImage, "midia_author" => $autor, "midia_type" => 'file', "midia_date" => date('Y-m-d H:i:s'),"midia_status"=>1];
                $insertGb = new Create;
                $insertGb->ExeCreate("ws_midias", $gbCreate);
                $u++;
            endif;
        endforeach;

        if ($u >= 1):
            $this->Error = ["Mídia Atualizada: Foram enviados <b>{$u}</b> arquivos para biblioteca!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    public function gbSendMedia(array $Images, $autor) {

        $this->Data = $Images;

        $gbFiles = array();
        $gbCount = count($this->Data['tmp_name']);
        $gbKeys = array_keys($this->Data);

        for ($gb = 0; $gb < $gbCount; $gb++):
            foreach ($gbKeys as $Keys):
                $gbFiles[$gb][$Keys] = $this->Data[$Keys][$gb];
            endforeach;
        endfor;

        $gbSend = new Upload;
        $i = 0;
        $u = 0;

        foreach ($gbFiles as $gbUpload):
            $i++;
            $ImageName = $gbUpload['name'];
            $ImgName = "{$ImageName}-gb-" . (substr(md5(time() + $i), 0, 8));

            $gbSend->Media($gbUpload, $ImgName);

            if ($gbSend->getResult()):
                $gbImage = $gbSend->getResult();
                $gbCreate = ["midia_file" => $gbImage, "midia_author" => $autor, "midia_type" => 'media', "midia_date" => date('Y-m-d H:i:s'),"midia_status"=>1];
                $insertGb = new Create;
                $insertGb->ExeCreate("ws_midias", $gbCreate);
                $u++;
            endif;
        endforeach;

        if ($u >= 1):
            $this->Error = ["Mídia Atualizada: Foram enviados <b>{$u}</b> mídias para biblioteca!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    /**
     * <b>Deleta Post:</b> Informe o ID do post a ser removido para que esse método realize uma checagem de
     * pastas e galerias excluinto todos os dados nessesários!
     * @param INT $PostId = Id do post
     */
    public function ExeDelete($PostId) {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE midia_id = :post", "post={$this->Post}");

        if (!$ReadPost->getResult()):
            $this->Error = ["A mídia que você tentou deletar não existe na biblioteca!", WS_ERROR];
            $this->Result = false;
        else:
            $PostDelete = $ReadPost->getResult()[0];
            if (file_exists($_SERVER['DOCUMENT_ROOT'].'/uploads/' . $PostDelete->midia_file) && !is_dir($_SERVER['DOCUMENT_ROOT'].'/uploads/' . $PostDelete->midia_file)):
                unlink($_SERVER['DOCUMENT_ROOT'].'/uploads/' . $PostDelete->midia_file);
            endif;
            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE midia_id = :postid", "postid={$this->Post}");

            $this->Error = ["A mídia <b>{$PostDelete->midia_file}</b> foi removida com sucesso da biblioteca!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    /**
     * <b>Ativa/Inativa Post:</b> Informe o ID do post e o status e um status sendo 1 para ativo e 0 para
     * rascunho. Esse méto ativa e inativa os posts!
     * @param INT $PostId = Id do post
     * @param STRING $PostStatus = 1 para ativo, 0 para inativo
     */
    public function ExeStatus($PostId, $PostStatus) {
        $this->Post = (int) $PostId;
        $this->Data['midia_status'] = (string) $PostStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE midia_id = :id", "id={$this->Post}");
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    //Cadastra o post no banco!
    private function Create() {

        $cadastra = new Create;
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["A mídia {$this->Data['midia_file']['name']} foi cadastrado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    //Atualiza o post no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE midia_id = :id", "id={$this->Post}");
        if ($Update->getResult()):
            $this->Error = ["A mídia foi atualizada com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

    public static function ListarImagem($type) {
        $read = new Read;
        $read->ExeRead(self::Entity,"where midia_type = :type and midia_status = true order by midia_id desc","type={$type}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }
    
    public static function ListarFile($type) {
        $read = new Read;
        $read->ExeRead(self::Entity,"where midia_type = :type and midia_status = true","type={$type}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }
    
    public static function ListarMidia($type) {
        $read = new Read;
        $read->ExeRead(self::Entity,"where midia_type = :type and midia_status = true","type={$type}");
        if ($read->getResult()):
            return $read->getResult();
        endif;
    }

}
