<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/conecta.php';
global $db, $mysqli, $pt;

$reference_code = time();

if (isset($_SESSION['userloginAdmin'])) {

    if (isset($input_post['action']) && $input_post['action'] == 'api_create') {
        unset($input_post['action']);
        /* echo '<pre>';
          var_dump($input_post);
          echo '</pre>'; */

        $api = $db->insert('ws_apis', [
            'name' => $input_post['name'],
            'order_end_point' => $input_post['order_end_point'],
            'order_method' => $input_post['order_method'],
            'user_id' => $input_post['user_id'],
            'status' => $input_post['status'],
            'created_at' => date('Y-m-d H:i:s'),
        ]);

        if (isset($input_post['order_key'])) {
            $order_keys = $input_post['order_key'];
            $order_key_values = $input_post['order_key_value'];
            $order_key_types = $input_post['order_key_type'];

            for ($i = 0; $i < count($order_keys); $i++) {

                $insertParamOne = $db->insert('api_request_params', [
                    'param_key' => trim($order_keys[$i]),
                    'param_value' => trim($order_key_values[$i]),
                    'param_type' => trim($order_key_types[$i]),
                    'api_type' => 'order',
                    'api_id' => $api,
                ]);
            }
        }
        /* $input_post['created_at'] = date('Y-m-d H:i:s');

          $insert = $db->insert('ws_api', $input_post); */

        if ($api) {
            echo json_encode(['status' => 200, 'type' => 'apis', 'id' => $api, 'code' => 'success', 'msg' => 'Informações registradas com sucesso!']);
        } else {
            echo json_encode(['status' => 400, 'code' => 'danger', 'msg' => 'Erro ao tentar enviar informações!']);
        }
    }
    if (isset($input_post['action']) && $input_post['action'] == 'api_update') {
        $id = (int) $input_post['id'];
        unset($input_post['action'], $input_post['id']);

        $api = $db->where('id', $id)->update('ws_apis', [
            'name' => $input_post['name'],
            'order_end_point' => $input_post['order_end_point'],
            'order_method' => $input_post['order_method'],
            'user_id' => $input_post['user_id'],
            'status' => $input_post['status'],
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
//        echo '<pre>';
//        var_dump($input_post);
//        echo '</pre>';
        $delete = $db->where('api_id', $id)->delete('api_request_params');

        if (isset($input_post['order_key'])) {
            $order_keys = $input_post['order_key'];
            $order_key_values = $input_post['order_key_value'];
            $order_key_types = $input_post['order_key_type'];

            for ($i = 0; $i < count($order_keys); $i++) {

                $insertParamOne = $db->insert('api_request_params', [
                    'param_key' => trim($order_keys[$i]),
                    'param_value' => trim($order_key_values[$i]),
                    'param_type' => trim($order_key_types[$i]),
                    'api_type' => 'order',
                    'api_id' => $id,
                ]);
            }
        }
        if ($api) {
            echo json_encode(['status' => 200, 'type' => 'apis', 'id' => $id, 'code' => 'success', 'msg' => 'Informações atualizadas com sucesso!']);
        } else {
            echo json_encode(['status' => 400, 'code' => 'danger', 'msg' => 'Erro ao tentar atualizar informações!']);
        }
    }


    if (isset($input_post['action']) && $input_post['action'] == 'retorna_dados') {
        if (isset($input_post['api_id'])) {
            $id = (int) $input_post['api_id'];
            $post_id = (int) $input_post['post_id'];
            $posto = $db->where('post_id', $post_id)->getOne('ws_posts');

            $db->rawQuery("ALTER TABLE `ws_combustivel_posto` ADD `codigoProduto` INT NOT NULL DEFAULT '0' AFTER `valor_desconto`;");

            $api = $db->where('id', $id)->getOne('ws_apis');
            if ($api) {


                $params = [];
                $params['CHAVE'] = $posto->post_api_token;
                $apiRequestParams = $db->where('api_id', $api->id)->get('api_request_params');
                if ($apiRequestParams) {


                    foreach ($apiRequestParams as $row) {
                        if ($row->param_type == 'custom') {
                            if (empty($row->param_key) && empty($row->param_value)) {
                                $api->order_end_point = $api->order_end_point . '/' . $posto->post_api_token;
                            }
                            $params[$row->param_key] = $row->param_value;
                        }
                    }

                    // create new client and make call
                    $client = new \GuzzleHttp\Client();
                    try {

                        // if Method is GET then change request key in Guzzle
                        $param_key = 'form_params';
                        if ($api->order_method === 'GET') {
                            $param_key = 'query';
                        }
                        if (empty($row->param_key) && empty($row->param_value)) {
                            $res = get_content($api->order_end_point);
                            $i = 0;
                            foreach ($res as $keys => $value) {
                                if (isset($value->fantasiaEmpresa) && isset($value->precoBomba)) {
                                    $desconto = str_replace('-', '', $value->precoClubgas);
                                    $array_data = array(
                                        'valor_antigo' => $value->precoBomba,
                                        'valor_novo' => ($value->precoBomba - $desconto),
                                        'posto_id' => $post_id,
                                        'valor_desconto' => $desconto,
                                    );

                                    $IfExistsProduct = $db->where('codigoProduto', $value->codigoProduto)->where('posto_id', $post_id)->getOne('ws_combustivel_posto');
                                    if ($IfExistsProduct) {
                                        $registra = $db->where('codigoProduto', $value->codigoProduto)->where('posto_id', $post_id)->update('ws_combustivel_posto', $array_data);
                                    } /*else {
                                        $array_data['codigoProduto'] = $value->codigoProduto;
                                        $registra = $db->insert('ws_combustivel_posto', $array_data);
                                    }*/
                                }
                                $i++;
                            }
                        } else {
                            $res = $client->request($api->order_method, $api->order_end_point, [
                                $param_key => $params,
                                'headers' => ['Accept' => 'application/json'],
                            ]);

                            if ($res->getStatusCode() === 200) {

                                $resp = $res->getBody()->getContents();

                                $resp = json_decode($resp);
                                $params_key = array_keys($params);
                                $params_keys = count($params_key);
                                $i = 0;
                                foreach ($resp as $keys => $value) {
                                    if (isset($value->fantasiaEmpresa) && isset($value->precoBomba)) {
                                        $desconto = str_replace('-', '', $value->precoClubgas);
                                        $array_data = array(
                                            'combustivel' => $value->nomeProduto,
                                            'valor_antigo' => $value->precoBomba,
                                            'valor_novo' => ($value->precoBomba - $desconto),
                                            'posto_id' => $post_id,
                                            'valor_desconto' => $desconto,
                                        );

                                        $IfExistsProduct = $db->where('codigoProduto', $value->codigoProduto)->where('posto_id', $post_id)->getOne('ws_combustivel_posto');
                                        if ($IfExistsProduct) {
                                            $registra = $db->where('codigoProduto', $value->codigoProduto)->where('posto_id', $post_id)->update('ws_combustivel_posto', $array_data);
                                        } else {
                                            $array_data['codigoProduto'] = $value->codigoProduto;
                                            $registra = $db->insert('ws_combustivel_posto', $array_data);
                                        }
                                    }
                                    $i++;
                                }
                            }
                        }
                        echo json_encode(array('status' => 200));
                    } catch (ClientException $e) {
                        
                    }
                }
            }
        }
    }
}