<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/conecta.php';

global $db;

$numeroCartao = '';
$inputCombustivel = '';
$inputValor = '';
$post_name = '';
$combustivel_id = '';
$grupo_periodicidade_dinheiro = '';
$grupo_periodicidade_volume = '';
$db->rawQuery("ALTER TABLE `abastecimentos` ADD `combustivel_id` INT(11) NULL DEFAULT NULL AFTER `produto`;");
$db->rawQuery("ALTER TABLE `abastecimentos` ADD `valor_novo_abastecimento` DECIMAL(12,2) NULL DEFAULT NULL AFTER `hora`, ADD `valor_antigo_abastecimento` DECIMAL(12,2) NULL DEFAULT NULL AFTER `valor_novo_abastecimento`, ADD `litros_abastecidos` VARCHAR(100) NULL DEFAULT NULL AFTER `valor_antigo_abastecimento`;");

if (!empty($_POST)) {
    $post_name = PT_Secure($_POST['post_name']);
    $inputValor = 0;
    if (isset($_POST['valorAbastecimento'])) {
        $inputValor = troca_virgula_por_ponto(PT_tira_ponto(PT_Secure($_POST['valorAbastecimento'])));
    }
    $inputCombustivel = PT_Secure($_POST['combustivel']);
    $combustivel_id = PT_Secure($_POST['combustivel_id']);
    $numeroCartao = PT_Secure($_POST['numeroCartao']);

    $infoPosto = $db->where('post_name', $post_name)->getOne('ws_posts');

    if (empty($numeroCartao) || !is_numeric($numeroCartao)) {
        die;
    }
    if (empty($inputValor) || !isset($inputValor) || $inputValor == 0 || empty($inputCombustivel) || !isset($inputCombustivel)) {
        echo json_encode(['tipo' => 'vazio', 'msg' => 'A SELEÇÃO DO COMBUSTÍVEL E O PREENCHIMENTO DO VALOR, SÃO NECESSÁRIOS PARA CONCLUIR A VENDA', 'status' => 305]);
        die;
    }
    $cliente = $db->where('cartao_rfid', $numeroCartao)->orWhere('cartao_numero', $numeroCartao)->getOne('ws_cartoes');
    if ($cliente) {
        $grupo = $db->where('grupo_nome', $cliente->cartao_grupo)->getOne('ws_grupos');
        $periodicidade = $grupo->grupo_periodicidade;
        if (!empty($grupo->grupo_periodicidade_dinheiro)) {
            $grupo_periodicidade_dinheiro = $grupo->grupo_periodicidade_dinheiro;
        }
        if (!empty($grupo->grupo_periodicidade_volume)) {
            $grupo_periodicidade_volume = $grupo->grupo_periodicidade_volume;
        }
        $quantidade = $grupo->grupo_quantidade;
        $limiteDinheiro = $grupo->grupo_limite_dinheiro;
        $limiteVolume = $grupo->grupo_limite_volume;

        $reg_combustiveis = $db->where('combustivel', $inputCombustivel)->where('posto_id', $infoPosto->post_id)->getOne('ws_combustivel_posto');

        $valor_antigo_combustivel = ($reg_combustiveis->valor_antigo) ? (float) $reg_combustiveis->valor_antigo : (float) '10.00';
        $valor_novo_combustivel = ($reg_combustiveis->valor_novo) ? (float) $reg_combustiveis->valor_novo : (float) '10.00';

        if ($valor_novo_combustivel <= 0) {
            $valor_novo_combustivel = 3.89;
        }
        if ($valor_antigo_combustivel <= 0) {
            $valor_antigo_combustivel = 3.89;
        }

        if (isset($infoPosto->post_identification_card) && $infoPosto->post_identification_card == 1) {
            $val_litros = LitrosAbastecidos($inputValor, number_format($valor_novo_combustivel, 2, '.', ''));
        } else {
            $val_litros = LitrosAbastecidos($inputValor, number_format($valor_antigo_combustivel, 2, '.', ''));
        }

        $values = array(
            'valor' => $inputValor,
            'posto' => $infoPosto->post_cnpj,
            'data' => date("Y-m-d"),
            'hora' => date("H:i:s"),
            'cartao' => $numeroCartao,
            'produto' => $inputCombustivel,
            'combustivel_id' => $combustivel_id,
            'valor_novo_abastecimento' => $reg_combustiveis->valor_novo,
            'valor_antigo_abastecimento' => $reg_combustiveis->valor_antigo,
            'litros_abastecidos' => $val_litros,
        );
        $inserir = $db->insert('abastecimentos', $values);
        if ($inserir) {
            echo json_encode(['tipo' => 'sucesso', 'msg' => 'Abastecimento realizado com sucesso!', 'status' => 200, 'numeroCartao' => $numeroCartao, 'post_name' => $post_name]);
            die;
        }
    }
}

