<?php

require_once $_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/conecta.php';
global $db;

$numeroCartao = '';
$inputCombustivel = '';
$inputValor = '';
$post_name = '';

if (isset($_REQUEST)) {

    $numeroCartao = PT_limpaCPF_CNPJ(PT_Secure($_REQUEST['numeroCartao']));
    if (isset($_REQUEST["combustivel"])) {
        $inputCombustivel = PT_Secure($_REQUEST["combustivel"]);
    }
    if (isset($_REQUEST["valorAbastecimento"])) {
        $inputValor = PT_Secure($_REQUEST["valorAbastecimento"]);
    }
    if (isset($_REQUEST["post_name"])) {
        $post_name = PT_Secure($_REQUEST["post_name"]);
    }

    $infoPosto = $db->where('post_name', $post_name)->getOne('ws_posts');

    $values = array(
        'valor' => $inputValor,
        'posto' => $infoPosto->post_cnpj,
        'data' => date("Y-m-d"),
        'hora' => date("H:i:s"),
        'cartao' => $numeroCartao,
        'produto' => $inputCombustivel
    );

    $cliente = $db->where('cartao_rfid', $numeroCartao)->getOne('ws_cartoes');
    if (!$cliente) {
        echo json_encode(['tipo' => 'cartao_nao_cadastrado', 'msg' => 'cartão não cadastrado', 'status' => 300, 'numeroCartao' => $numeroCartao]);
        die; 
    }
    
    $placaVeiculo = $cliente->cartao_placa;
    if ($cliente->cartao_status != "ATIVO") {
        echo json_encode(['tipo' => 'cliente_inativo', 'msg' => 'ABASTECIMENTO NAO AUTORIZADO', 'status' => 300, 'numeroCartao' => $numeroCartao]);
        die;
    }
    
    $abastecimentos = $db->where('cartao', $numeroCartao)->get('abastecimentos');
    $grupo = $db->where('grupo_nome', $cliente->cartao_grupo)->getOne('ws_grupos');
    $periodicidade = $grupo->grupo_periodicidade;
    $grupo_periodicidade_dinheiro = $grupo->grupo_periodicidade_dinheiro;
    $grupo_periodicidade_volume = $grupo->grupo_periodicidade_volume;
    $quantidade = $grupo->grupo_quantidade;
    $limiteDinheiro = $grupo->grupo_limite_dinheiro;
    $limiteVolume = $grupo->grupo_limite_volume;

    if ($periodicidade == "dia") {
        $dataVerificacao = date("Y-m-d");
        $abastecimentosDia = $db->where('cartao', $numeroCartao)->where("data", $dataVerificacao)->get('abastecimentos');
        if (count($abastecimentosDia) >= $quantidade) {
            echo json_encode(['tipo' => 'excedido', 'msg' => 'limite de abastecimento excedido', 'status' => 301, 'numeroCartao' => $numeroCartao]);
            die;
        }
    } else if ($periodicidade == "semana") {
        $dataVerificacao = date("Y-m-d") - 7;
        $abastecimentosSemana = $db->where('cartao', $numeroCartao)->where("data", $dataVerificacao)->get('abastecimentos');
        if (count($abastecimentosSemana) >= $quantidade) {
            echo json_encode(['tipo' => 'excedido', 'msg' => 'limite de abastecimento excedido', 'status' => 302, 'numeroCartao' => $numeroCartao]);
            die;
        }
    } else if ($periodicidade == "mês") {
        $dataVerificacao = date("Y-m-d") - 30;
        $abastecimentosMes = $db->where('cartao', $numeroCartao)->where("data", $dataVerificacao)->get('abastecimentos');
        if (count($abastecimentosMes) >= $quantidade) {
            echo json_encode(['tipo' => 'excedido', 'msg' => 'limite de abastecimento excedido', 'status' => 303, 'numeroCartao' => $numeroCartao]);
            die;
        }
    } else if ($periodicidade == "ano") {
        $dataVerificacao = date("Y-m-d") - 365;
        $abastecimentosAno = $db->where('cartao', $numeroCartao)->where("data", $dataVerificacao)->get('abastecimentos');
        if (count($abastecimentosAno) >= $quantidade) {
            echo json_encode(['tipo' => 'excedido', 'msg' => 'limite de abastecimento excedido', 'status' => 304, 'numeroCartao' => $numeroCartao]);
            die;
        }
    }

    $resultado = "Abastecimento autorizado PLACA: " . $placaVeiculo;
    if ($resultado) {
        echo json_encode(['tipo' => 'autorizado', 'msg' => $resultado, 'status' => 200, 'placa' => $placaVeiculo, 'numeroCartao' => $numeroCartao, 'post_name' => $post_name]);
        die;
    }
}

