<?php

/**
 * AdminPost.class [ MODEL ADMIN ]
 * Respnsável por gerenciar os posts no Admin do sistema!
 * 
 * @copyright (c) 2014, Alisson MAciel
 */
class AdminDepoimentos {

    private $Data;
    private $Post;
    private $Error;
    private $Result;
    private $Type;

    //Nome da tabela no banco de dados
    const Entity = PREFIX.'depoimentos';

    public function PostType($Type) {
        $this->Type = (string) $Type;
    }

    /**
     * <b>Cadastrar o Post:</b> Envelope os dados do post em um array atribuitivo e execute esse método
     * para cadastrar o post. Envia a capa automaticamente!
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        $this->setData();
        $this->setName();

        if ($this->Data['depoimento_img']):
            $uplaod = new Upload;
            $uplaod->Image($this->Data['depoimento_img'], $this->Data['depoimento_name']);
        endif;

        if (isset($uplaod) && $uplaod->getResult()):
            $this->Data['depoimento_img'] = $uplaod->getResult();
            $this->Create();
        else:
            $this->Data['depoimento_img'] = null;
            $this->Create();
        endif;
    }

    /**
     * <b>Atualizar Post:</b> Envelope os dados em uma array atribuitivo e informe o id de um 
     * post para atualiza-lo na tabela!
     * @param INT $PostId = Id do post
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        $this->setData();
        $this->setName();

        if (is_array($this->Data['depoimento_img'])):
            $readCapa = new Read;
            $readCapa->ExeRead(self::Entity, "WHERE depoimento_id = :post", "post={$this->Post}");
            $capa = '../uploads/' . $readCapa->getResult()[0]->depoimento_img;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;

            $uploadCapa = new Upload;
            $uploadCapa->Image($this->Data['depoimento_img'], $this->Data['depoimento_name']);
        endif;

        if (isset($uploadCapa) && $uploadCapa->getResult()):
            $this->Data['depoimento_img'] = $uploadCapa->getResult();
            $this->Update();
        else:
            unset($this->Data['depoimento_img']);
            $this->Update();
        endif;
    }

    /**
     * <b>Deleta Post:</b> Informe o ID do post a ser removido para que esse método realize uma checagem de
     * pastas e galerias excluinto todos os dados nessesários!
     * @param INT $PostId = Id do post
     */
    public function ExeDelete($PostId) {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE depoimento_id = :post", "post={$this->Post}");

        if (!$ReadPost->getResult()):
            $this->Error = ["O depoimento que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else:
            $PostDelete = $ReadPost->getResult()[0];
            if (file_exists('../uploads/' . $PostDelete->depoimento_img) && !is_dir('../uploads/' . $PostDelete->depoimento_img)):
                unlink('../uploads/' . $PostDelete->depoimento_img);
            endif;

            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE depoimento_id = :postid", "postid={$this->Post}");

            $this->Error = ["O depoimento <b>{$PostDelete->depoimento_title}</b> foi removido com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    /**
     * <b>Ativa/Inativa Post:</b> Informe o ID do post e o status e um status sendo 1 para ativo e 0 para
     * rascunho. Esse méto ativa e inativa os posts!
     * @param INT $PostId = Id do post
     * @param STRING $PostStatus = 1 para ativo, 0 para inativo
     */
    public function ExeStatus($PostId, $PostStatus) {
        $this->Post = (int) $PostId;
        $this->Data['depoimento_status'] = (string) $PostStatus;
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE depoimento_id = :id", "id={$this->Post}");
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna ID do registro se o cadastro for efetuado ou FALSE se não.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = InsertID or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida e cria os dados para realizar o cadastro
    private function setData() {
        $Cover = $this->Data['depoimento_img'];
        $Content = $this->Data['depoimento_description'];

        unset($this->Data['depoimento_img'], $this->Data['depoimento_description']);

        $this->Data = array_map('strip_tags', $this->Data);
        $this->Data = array_map('trim', $this->Data);
        $Check = new Check();
        $this->Data['depoimento_name'] = $Check->Name($this->Data['depoimento_title']);
        $this->Data['depoimento_date'] = $Check->Data($this->Data['depoimento_date']);
        $this->Data['depoimento_img'] = $Cover;
        $this->Data['depoimento_description'] = $Content;
    }
    //Verifica o NAME post. Se existir adiciona um pós-fix -Count
    private function setName() {
        $Where = (isset($this->Post) ? "depoimento_id != {$this->Post} AND" : '');
        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} depoimento_title = :t", "t={$this->Data['depoimento_title']}");
        if ($readName->getResult()):
            $this->Data['depoimento_name'] = $this->Data['depoimento_name'] . '-' . $readName->getRowCount();
        endif;
    }

    //Cadastra o post no banco!
    private function Create() {
        $cadastra = new Create;
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["O depoimento {$this->Data['depoimento_title']} foi cadastrado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    //Atualiza o post no banco!
    private function Update() {
        $Update = new Update;
        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE depoimento_id = :id", "id={$this->Post}");
        if ($Update->getResult()):
            $this->Error = ["O depoimento <b>{$this->Data['depoimento_title']}</b> foi atualizado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
