<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of CurlVindi
 *
 * @author aliss
 */
class CurlVindi {

    private $sandbox = true;
    private $endpoint = '';
    private $api_key = '';
    private $id;

    function __construct($sandbox, $endpoint, $api_key) {
        $this->sandbox = $sandbox;
        $this->endpoint = $endpoint;
        $this->api_key = $api_key;
    }

    private function sandbox() {
        if ($this->sandbox == true):
            $url = 'https://sandbox-app.vindi.com.br/api/v1/';
        else:
            $url = 'https://app.vindi.com.br/api/v1/';
        endif;
        return $url;
    }

    public function CreateCustomer(array $params) {
        error_reporting(E_ALL);
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            return json_decode($result);
            $log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        print_r($log);
    }

    public function UpdateCustomer(array $params, $id) {
        $this->id = $id;
        error_reporting(E_ALL);
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            return json_decode($result);
            $log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        print_r($log);
    }

    public function getCustomer($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);

        return $retorno;
    }

    public function getProduto($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);

        return $retorno;
    }

    public function getALL($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);

        return $retorno;
    }

    public function getFatura($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
//echo '<pre>';
//var_dump($retorno['bills']);
//echo '</pre>';
        return $retorno['bill'];
    }

    public function getFaturaWebHook($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        return $retorno['bill'];
        if (isset($retorno['bills'])):
            //$res = $retorno['bills'][0];
            curl_close($ch);
            return $res;
        endif;
    }

    public function getFaturaWebHookFrete($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id . '?sort_by=id&sort_order=desc');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        return $retorno['bills'][0];
    }

    public function getPaymentProfile($id) {
        $this->id = $id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/' . $this->id);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        $retorno = (array) $retorno;
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);

        return $retorno['payment_profile'];
    }

    public function CancelSubscription($id) {

        $this->id = $id;
        $url = $this->sandbox() . $this->endpoint . '/' . $this->id . '?cancel_bills=true';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        $retorno = (array) $retorno;
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);

        return $retorno[$this->endpoint];
    }
    
    public function CancelBills($id) {

        $this->id = $id;
        $url = $this->sandbox() . $this->endpoint . '/' . $this->id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        $response = curl_exec($ch);       
        //$retorno = @json_decode($response, true);
        //$retorno = (array) $retorno;
       //if (!$retorno) {
         //   $retorno = $response;
       // }
        curl_close($ch);

        //return $retorno;
    }

    public function CancelPaymentsProfile($id) {

        $this->id = $id;
        $url = $this->sandbox() . $this->endpoint . '/' . $this->id;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        $result = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    }

    public function RetornaPlanos() {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        if (isset($retorno['plans'])):
            return $retorno['plans'];
        endif;
    }

    public function RetornaSubscriptions() {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        if (isset($retorno['subscriptions'])):
            return $retorno['subscriptions'];
        endif;
    }

    public function RetornaPaymentsProfiles() {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '?sort_by=id&sort_order=desc');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        if (isset($retorno[$this->endpoint])):
            return $retorno[$this->endpoint];
        endif;
    }

    public function RetornaALL() {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '?sort_by=id&sort_order=desc');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        if (isset($retorno[$this->endpoint])):
            return $retorno[$this->endpoint];
        endif;
    }

    public function RetornaFaturas() {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '?sort_by=id&sort_order=desc');
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json'
        ));
        $response = curl_exec($ch);
        $error = curl_error($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $retorno = @json_decode($response, true);
        if (!$retorno) {
            $retorno = $response;
        }
        curl_close($ch);
        if (isset($retorno[$this->endpoint])):
            return $retorno[$this->endpoint];
        endif;
    }

    public function CreateSubscription(array $params) {
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            return json_decode($result, JSON_PRETTY_PRINT);
            // $log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        //print_r($log);
    }

    public function CreateProfilePayment(array $params) {
        error_reporting(E_ALL);
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $result = json_decode($result);
            $return = (array) $result;

            $resulta = [];
            $resulta['id'] = $return['payment_profile']->id;
            return $resulta;



            //$log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        //print_r($log);
    }

    public function CreateFaturaPayment(array $params) {
        error_reporting(E_ALL);
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            return json_decode($result);
            $log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        print_r($log);
    }

    public function CreateProduto(array $params) {
        error_reporting(E_ALL);
        $params = json_encode($params);

        $fp = fopen('log_curl.txt', 'a');

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, "{$this->sandbox()}" . $this->endpoint . '/');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, $this->api_key . ':');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['content-type: application/json']);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        try {
            $result = curl_exec($ch);
        } catch (Exception $e) {

            return $e->getError();
        }

        if (isset($result)) {
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            return json_decode($result);
            $log = fputs($fp, sprintf('%s%s - Resposta da API: Código %s%s%s', "\n", date('d/m/Y H:i:s'), $httpcode, "\n", $result));
        }

        fclose($fp);
        curl_close($ch);
        print_r($log);
    }

}
