<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->

        <!-- Main content -->
        <section class="content">
            <!-- Main content -->
            <div class="row">
                <div id="load"></div>
                <div class="msg"></div>

                <div class="col-md-8">
                    <!-- BEGIN SAMPLE FORM PORTLET-->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fa fa-cog"></i> Configurações
                            </h3>
                            <div class="tools">
                                <button id="btnReload" type="button" class="btn btn-danger">
                                    <i class="glyphicon glyphicon-triangle-right"></i> Carregar Menu</button>
                            </div>
                        </div>
                        <div class="card-content" id="cont">
                            <div class="card-body table-responsive">
                                <div id="msg"></div>

                                <ul id="myEditor" class="sortableLists list-group">
                                </ul>

                                <div class="form-group">
                                    <button id="btnOut" type="button" class="btn btn-primary"><i class="glyphicon glyphicon-ok"></i> Clique aqui antes de salvar</button>
                                    <button id="salvar" type="button" class="btn btn-success pull-right"><i class="fa fa-save"></i> Salvar</button>
                                </div>
                                <div class="form-group">
                                    <textarea id="out" class="form-control" cols="50" rows="10" readonly="">
                                        
                                    </textarea>
                                    <input type="hidden" id="id_menu_json" />
                                </div>

                            </div>
                        </div>


                    </div>
                    <!-- END SAMPLE FORM PORTLET-->
                </div>

                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fa fa-cogs"></i> Mais configurações
                            </h3>
                            <div class="tools">
                            </div>
                        </div>
                        <div class="card-content">
                            <div class="card collapse-icon accordion-icon-rotate left">

                                <div id="headingCollapse1" class="card-header pb-3">
                                    <a data-toggle="collapse" href="#collapse1" aria-expanded="true" aria-controls="collapse1" class="card-title lead">
                                        Categorias</a>
                                </div>

                                <div id="collapse1" role="tabpanel" aria-labelledby="headingCollapse1" class="collapse show" style="">
                                    <div class="card-content">
                                        <div class="card-body">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <select class="form-control" name="categorias" data-placeholder="Selecione uma opção" required="">
                                                        <option value="" selected="" disabled="">Selecione uma opção</option>
                                                        <?php foreach (selectCatSub() as $cl) { ?>
                                                            <option value="<?php echo $cl["category_id"] ?>"><?php echo $cl["category_title"]; ?> -- Tipo: <?php echo $cl["type"]; ?></option>
                                                        <?php } ?>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="headingCollapse2" class="card-header pb-3">
                                    <a data-toggle="collapse" href="#collapse2" aria-expanded="true" aria-controls="collapse2" class="card-title lead">
                                        Páginas/Posts/Produtos e etc</a>
                                </div>

                                <div id="collapse2" role="tabpanel" aria-labelledby="headingCollapse2" class="collapse" style="">
                                    <div class="card-content">
                                        <div class="card-body">
                                            <div class="form-group">
                                                    <div class="col-md-12">
                                                        <select class="form-control" name="post" data-placeholder="Selecione uma opção" required="">
                                                            <option value="" selected="" disabled="">Selecione uma opção</option>
                                                            <?php
                                                            $read = new Read;
                                                            $read->ExeRead("ws_posts", "order by post_id asc");
                                                            if ($read->getResult()):
                                                                foreach ($read->getResult() as $post):
                                                                    echo "<option value=\"{$post->post_id}\">{$post->post_title} <---------> Tipo: {$post->post_type}</option>";
                                                                endforeach;
                                                            endif;
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <form id="frmEdit" class="form-horizontal">
                                    <div class="form-group">
                                        <label for="text">Nome/Label</label>
                                        
                                            <div class="input-group">
                                                <input type="text" class="form-control item-menu" name="text" id="text" placeholder="Nome/Label">
                                                <div class="input-group-btn">
                                                    <button type="button" id="myEditor_icon" class="btn btn-default" data-iconset="fontawesome"></button>
                                                </div>
                                                <input type="hidden" name="icon" class="item-menu">
                                            </div>
                                        
                                    </div>
                                    <div class="form-group">
                                        <label for="href">URL Ex.: /home</label>
                                        <input type="text" class="form-control item-menu" id="href" name="href" placeholder="URL">
                                    
                                    </div>
                                    <div class="form-group">
                                        <label for="target">Target</label>
                                       
                                            <select name="target" id="target" class="form-control item-menu">
                                                <option value="_self">Self</option>
                                                <option value="_blank">Blank</option>
                                                <option value="_top">Top</option>
                                            </select>
                                      
                                    </div>
                                    <div class="form-group">
                                        <label for="title">Tooltip/Titulo</label>
                                        
                                            <input type="text" name="title" class="form-control item-menu" id="title" placeholder="Tooltip/Titulo">
                                        
                                    </div>
                                </form>


                                <div class="clearfix"></div>
                            </div>
                            <div class="panel-footer">
                                <button type="button" id="btnUpdate" class="btn btn-primary" disabled><i class="fa fa-refresh"></i> Update</button>
                                <button type="button" id="btnAdd" class="btn btn-success"><i class="fa fa-plus"></i> Add</button>
                            </div>
                            <div class="clearfix"></div>

                        </div>
                    </div>
                </div>

            </div>
        </section>
    </div>    
</div>
<script src="<?= CAMINHO_ADMIN; ?>/assets/bs-iconpicker/js/jquery-menu-editor.js" type="text/javascript"></script>
<script src='<?= CAMINHO_ADMIN; ?>/assets/bs-iconpicker/js/iconset/iconset-fontawesome-4.2.0.min.js'></script>
<script src='<?= CAMINHO_ADMIN; ?>/assets/bs-iconpicker/js/bootstrap-iconpicker.js'></script>
<script>
    $(function () {
    
        $('#load').hide();
        $.ajax({
            method: 'post',
            url: '<?= CAMINHO_ADMIN; ?>/modulos/responds.php',
            data: 'acao=listar_menu',
            dataType: 'json',
            success: function(dados) {
               
                var base_url = window.location.origin;
                if (dados <= '0') {
                    $("#id_menu_json").val('0');
                    var strjson = '[{"href":"' + base_url + '","icon":"fa fa-home","text":"Home", "target": "_top", "title": "Home"}]';
                } else {
                    $("#id_menu_json").val(dados.id);
                    var strjson = dados.backend_json;
                }

                var iconPickerOpt = {cols: 5, searchText: "Buscar...", labelHeader: '{0} de {1} Pags.', footer: false};
                var options = {
                    hintCss: {'border': '1px dashed #13981D'},
                    placeholderCss: {'background-color': 'gray'},
                    opener: {
                        as: 'html',
                        close: '<i class="fa fa-minus"></i>',
                        open: '<i class="fa fa-plus"></i>',
                        openerCss: {'margin-right': '10px'},
                        openerClass: 'btn btn-success btn-xs'
                    }
                };
                var editor = new MenuEditor('myEditor', {listOptions: options, iconPicker: iconPickerOpt, labelEdit: 'Editar'});
                editor.setForm($('#frmEdit'));
                editor.setUpdateButton($('#btnUpdate'));

                /* $('#btnReload').on('click', function () {*/
                editor.setData(strjson);
                /*});*/
                $('#btnOut').on('click', function () {
                    var str = editor.getString();
                    $("#out").text(str);
                    if ($('#id_menu_json').val() == '') {
                        /*$("#id").val('0');*/
                    } else {
                        $("#id_menu_json").val(dados.id);
                    }

                });
                $("#btnUpdate").click(function () {
                    editor.update();
                });
                $('#btnAdd').click(function () {
                    editor.add();
                });

                $("#salvar").click(function () {

                    $.ajax({
                        type: "POST",
                        url: "<?= CAMINHO_ADMIN; ?>/modulos/responds.php",
                        data: 'acao=salvar_menu&json=' + $("#out").val() + '&id=' + $("#id_menu_json").val(),
                        beforeSend: function () {
                            $("#load").show();
                            $("#msg").html("<div class='alert alert-info'><img src='<?= CAMINHO_ADMIN; ?>/assets/admin/layout/img/ajax-loading.gif' alt='' style='width:25px;'/> Aguarde um momento</div>");
                        },
                        success: function (data) {
                            $('#load').hide();
                            $("#msg").html("<div class='alert alert-success suc'>Dados enviados com sucesso</div>");
                            location.reload();
                        },

                        error: function (request, status, error) {
                        }
                    });
                });

            }
        });

    });
</script>