<?php
$page = (!empty($input_get['page-id'])) ? $input_get['page-id'] : 1;
$filter_keyword = (!empty($input_get['query'])) ? ($input_get['query']) : '';
$filter_type = '';
$db->pageLimit = 20;
if (empty($linkto[3])) {
    $index = 'index';
} else {
    $index = $linkto[3];
}
if (!empty($filter_keyword)) {
    $sql = "`cupom_code` LIKE '%$filter_keyword%'";
    $cupons = $db->where($sql)->orderBy('cupom_id', 'DESC')->objectbuilder()->paginate('ws_cupons', $page);
} else {
    $cupons = $db->objectbuilder()->orderBy('cupom_id', 'desc')->paginate('ws_cupons', $page);
}
$count = count($db->get('ws_cupons'));
if (($page > $db->totalPages) && !empty($input_get['page-id'])) {
    header("Location: " . BASE . $_SERVER['REQUEST_URI']);
    exit();
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="main-content">
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section id="basic-form-layouts">
            <!-- Main content -->
            <div class="row">
                <!-- right column -->
                <div class="col-md-12">

                    <form action='<?= ADMIN; ?>/<?= $linkto[2]; ?>/index' method='get'>
                        <div class="col-lg-6 pull-right">
                            <a class="btn btn-info" href="<?= ADMIN; ?>/<?= $linkto[2]; ?>/inserir"><i class='fa fa-plus-circle'></i> Adicionar</a>
                        </div>
                        <div class="col-lg-6 pull-right">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Pesquisar por descrição, endpoint e etc" name='query' id='query'>
                                <span class="input-group-btn">
                                    <button class="btn btn-info" type="submit"><i class='fa fa-search'></i></button>
                                </span>
                            </div><!-- /input-group -->
                        </div><!-- /.col-lg-6 -->

                    </form>

                </div>
            </div>
            <div class="row">
                <!-- right column -->
                <!-- right column -->
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Listar Cupons</h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body table-responsive">
                                <table class="table text-center">
                                    <thead>
                                        <tr>
                                            <th style="width: 10px">#</th>
                                            <th>Código</th>
                                            <th>Tipo de cupom</th>
                                            <th>Valor R$/(%)</th>
                                            <th>Quantidade</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if ($cupons) {
                                            foreach ($cupons as $key => $cupom) {
                                                $status = ($cupom->cupom_status == 1) ? '<span class="label label-success">Active</span>' : '<span class="label label-danger">Inactive</span>';
                                                if ($cupom->cupom_type == 'percentage'):
                                                    $value = $cupom->cupom_value . '%';
                                                else:
                                                    $value = 'R$' . $cupom->cupom_value;
                                                endif;
                                                $text = ($cupom->cupom_status == 1) ? 'EXCLUIR' : 'ATIVAR';
                                                $color = ($cupom->cupom_status == 1) ? 'danger' : 'success';
                                                if ($cupom->cupom_type == 'amount') {
                                                    $cupom->cupom_type = 'Dinheiro Espécie';
                                                } else {
                                                    $cupom->cupom_type = 'Porcentagem';
                                                }


                                                $cupom_id = $cupom->cupom_id;
                                                ?>
                                                <tr id="list-<?= $cupom->cupom_id; ?>">
                                                    <td><?= $cupom->cupom_id; ?></td>
                                                    <td><?= $cupom->cupom_code; ?></td>
                                                    <td><?= $cupom->cupom_type; ?></td>
                                                    <td><?= $value; ?></td>
                                                    <td><?= $cupom->cupom_qtd ?></td>
                                                    <td><?= $status ?></td>
                                                    <td>
                                                        <a href="<?= ADMIN; ?>/<?= $linkto[2]; ?>/editar/<?= $cupom_id; ?>" class="btn btn-md btn-info"><i class="fa fa-edit"></i></a>
                                                        <button class="btn btn-md btn-danger waves-effect waves-light delete-content" data-id="<?= $cupom_id; ?>"><i class="fa fa-trash"></i></button>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                        }
                                        ?>                                
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="col-md-6 pull-left">
<?php echo "Total (" . $count . ") registros | Mostrando $page página(s) de " . $db->totalPages; ?>
                    </div>
                    <div class="col-md-6 pull-right">
                        <nav class="" aria-label="Page navigation mb-3">
                            <ul class="pagination justify-content-end">
                                <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=1" aria-label="Previous"><i class="fa fa-home"></i></a>
                                </li>
                                <?php if ($page > 1) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page - 1); ?>"><i class="fa fa-chevron-left"></i></a></li>
                                <?php } ?>
                                <?php
                                $nums = 0;
                                $nums_pages = ($page > 4) ? ($page - 4) : $page;
                                for ($i = $nums_pages; $i <= $db->totalPages; $i++) {
                                    if ($nums < 20) {
                                        ?>
                                        <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($i); ?>"><?php echo $i ?></a></li>
                                        <?php
                                    }
                                    $nums++;
                                }
                                ?>
                                <?php if ($db->totalPages > $page) { ?>
                                    <li class="page-item"><a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($page + 1); ?>"><i class="fa fa-chevron-right"></i></a></li>
<?php } ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= ADMIN; ?>/<?= $linkto[2] . '/' . $index; ?>?page-id=<?= ($db->totalPages); ?>" aria-label="Next"><i class="fa fa-forward"></i></a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
    </div>
    <!--/.col (right) -->
</div>
<!-- /.row -->
</section>
<!-- /.content -->
</div>
</div>
<div class="modal fade text-left" id="delete-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel10" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content modal-col-red">
            <div class="modal-header bg-danger white">
                <h4 class="modal-title" id="myModalLabel10">DELETAR REGISTRO</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja remover esse registro?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger waves-effect delete-button" data-dismiss="modal" data-type="<?= $linkto[2]; ?>">DELETAR</button>
                <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">FECHAR</button>
            </div>
        </div>
    </div>
</div>