<?php

require_once($_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/conecta.php');
//require $_SERVER['DOCUMENT_ROOT'] . '/admin/modulos/vendor/autoload.php';

use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;

$rand = uniqid();
$base = BASE;
$check = new Check;
$read = new Read;
$upload = new Upload;
$cadastra = new Create;
$update = new Update();
$delete = new Delete();
$carrinho = new Carrinho;
$sitename = SITENAME;
if (PHP_OS == "Linux")
    $quebra_linha = "\n";
elseif (PHP_OS == "WINNT")
    $quebra_linha = "\r\n";

global $db, $mysqli, $pt;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'pegaModelo') {
    unset($_POST['acao']);
    $_SESSION['modelo'][$_POST['post_id']] = $_POST['modelo_id'];
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'fechar_orcamento') {
    $table = '<table class="table table-bordered">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Produto</th>
                                <th>Modelo</th>
                                <th>Qtd.</th>
                                <th>Preço</th>
                            </tr>
                        </thead>
                        <tbody>';
    if (isset($_SESSION['qualiterme_carrinho'])) {
        $modelo = 'Sem modelo';
        foreach ($_SESSION['qualiterme_carrinho'] as $id => $quantidade) {
            $product = list_products_category($id);
            if (isset($_SESSION['modelo'][$id])) {
                $modelo = $_SESSION['modelo'][$id];
            }
            $table .= ' 
                                        <tr>
                                            <td><img style="height:50px;" src="' . BASE . '/' . $product->post_cover . '" alt="" class="pro-image-front"></td>
                                            <td>' . $product->post_title . '</td>
                                            <td>' . $modelo . '</td>
                                            <td>' . $quantidade . '</td>
                                            <td>' . $product->post_valor . '</td>
                                        </tr>';
        }
    }
    $table .= '</tbody></table>';

    $Contato['mensagem'] = "Nome: {$_POST['nome']}<br>"
            . "E-mail: {$_POST['email']}<br>"
            . "Telefone: {$_POST['telefone']}<br>"
            . "Empresa: {$_POST['empresa']}<br>"
            . "CNPJ: {$_POST['cnpj']}<br><br>" . $table;


    $Template = new TemplateEmail("Orçamento: " . SITENAME, $Contato['mensagem'], '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                            <a href="' . BASE . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $logomarcaAdmin);

    $Mensagem = $Template->Template();
    $enviaEmail = new enviaEmail($pt->config->email, "Orçamento: " . SITENAME, $Mensagem, $_POST['email'], $_POST['nome']);
    $enviaEmail->enviar();

    /* fim da mensagem para o administrador do site */

    /* mensagem de retorno para o usuario que solicitou contato */
    $Template = new TemplateEmailRetorno("Orçamento: " . SITENAME, "Olá {$_POST['nome']},<br>Verificamos que você solicitou um Orçamento.<br><br>"
            . "<strong>Segue abaixo seu Orçamento:</strong><br>{$Contato['mensagem']}<br><br>Equipe " . SITENAME . "<br>", '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                            <a href="' . BASE . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $logomarcaAdmin);

    $enviaEmail = new enviaEmail($_POST['email'], "Orçamento: " . SITENAME, $Mensagem, $pt->config->email, SITENAME);
    if ($enviaEmail->enviar()) {
        echo json_encode(array('msg' => 'Orçamento enviado com sucesso', 'code' => 'success'));
        if (isset($_SESSION['qualiterme_carrinho'])) {
            foreach ($_SESSION['qualiterme_carrinho'] as $id => $quantidade) {
                $id = (int) $id;
                $carrinho->deletarProduto($id);
            }
        }
    } else {
        echo json_encode(array('msg' => 'Erro ao tentar enviar orçamento', 'code' => 'danger'));
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'manual') {
    $id = (int) $_POST['post_id'];
    $manual = '';
    $table = '<table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Manual</th>
                                <th>Download</th>
                            </tr>
                        </thead>
                        <tbody>';

    $product = list_products_category($id, 'manuais');
    $galeria = $db->where('post_id', $id)->getOne('ws_posts_gallery');
    if ($galeria) {
        $manual = $galeria->gallery_image;
    }
    $table .= ' 
                                        <tr><td>' . $product->post_title . '</td>
                                        <td><a href="' . BASE . '/' . $manual . '">Download do manual</a></td>                                           
                                        </tr>';

    $table .= '</tbody></table>';

    $Contato['mensagem'] = "Nome: {$_POST['nome']}<br>"
            . "E-mail: {$_POST['email']}<br>"
            . "Telefone: {$_POST['telefone']}<br>"
            . "Empresa: {$_POST['empresa']}<br>"
            . "CNPJ: {$_POST['cnpj']}<br>"
            . "Nota fiscal: {$_POST['nota']}<br>"
            . "Número de série: {$_POST['serie']}<br><br>" . $table;


    $Template = new TemplateEmail("Manual: " . SITENAME, $Contato['mensagem'], '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                            <a href="' . BASE . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $logomarcaAdmin);

    $Mensagem = $Template->Template();
    $enviaEmail = new enviaEmail($pt->config->email_manual, "Manual: " . SITENAME, $Mensagem, $_POST['email'], $_POST['nome']);
    $enviaEmail->enviar();

    /* fim da mensagem para o administrador do site */

    /* mensagem de retorno para o usuario que solicitou contato */
    $Template = new TemplateEmailRetorno("Manual: " . SITENAME, "Olá {$_POST['nome']},<br>Verificamos que você fez um pedido de manual.<br><br>"
            . "<strong>Segue abaixo seu pedido de manual:</strong><br>{$Contato['mensagem']}<br><br>Equipe " . SITENAME . "<br>", '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                            <a href="' . BASE . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $logomarcaAdmin);

    $enviaEmail = new enviaEmail($_POST['email'], "Manual: " . SITENAME, $Mensagem, $pt->config->email_manual, SITENAME);
    if ($enviaEmail->enviar()) {
        echo json_encode(array('msg' => 'Manual solicitado com sucesso', 'link' => $manual, 'code' => 'success'));
    } else {
        echo json_encode(array('msg' => 'Erro ao tentar solicitar manual', 'code' => 'danger'));
    }
}

if (isset($_SESSION['userlogin'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'fechar_pedido_pagseguro'):

        if (!empty($_POST['pacote'])) {
            $pacote_id = (int) $_POST['pacote'];

            $pct = $db->where('post_id', $pacote_id)->getOne('ws_posts');

            $data = array();

            $ref = time();

            $data['email'] = $pt->config->config_email_pagseguro;
            $data['token'] = $pt->config->config_token_pagseguro;
            $data['currency'] = 'BRL';
            $data['itemId1'] = $pacote_id;
            $data['itemDescription1'] = 'Compra pacote #' . $pacote_id;
            $data['itemAmount1'] = $pct->post_valor;
            $data['itemQuantity1'] = '1';
            $data['reference'] = $ref;
            $data['senderName'] = removeAcentos($_SESSION['userlogin']->user_name);
            $data['senderAreaCode'] = DDD($_POST['telefone']);
            $data['senderPhone'] = FONE($_POST['telefone']);
            $data['senderEmail'] = $_SESSION['userlogin']->user_email;
            $data['notificationURL'] = $pt->config->config_url_retorno_pagseguro;
            $data['redirectURL'] = BASE . '/painel';

            $xml = pagseguro_checkout_basico($data);
            if ($xml == 'Unauthorized') {
                echo json_encode(array('resposta' => 'Unauthorized', 'code' => 'danger'));
                exit;
            }
            if (isset($xml->error) && count($xml->error) > 0) {
                echo json_encode(array('resposta' => 'Dados inválidos', 'code' => 'danger'));
                exit;
            }
            echo json_encode(array('link' => 'https://pagseguro.uol.com.br/v2/checkout/payment.html?code=' . $xml->code, 'code' => 'success'));

            $code_pagseguro = $xml->code;
            $dados_fatura_create = array(
                'amount' => $pct->post_valor,
                'id_invoice' => $code_pagseguro,
                'status' => 'Aguardando pagamento',
                'id_user' => $_SESSION['userlogin']->user_id,
                'acquirer_name' => 'pagseguro',
                'type' => 'fatura_avulsa',
                'code_assinatura' => $pct->post_id,
                'reference' => $ref,
                'data_criacao' => date('Y-m-d H:i:s'),
            );
            $insert = $db->insert('ws_faturas', $dados_fatura_create);
            // $idTransacao = $user_home->AdicionarSaldoPaypal($_SESSION['userlogin']->id, $input_post['itemAmount1'], 'PagSeguro', 'PS', $ref, $paypalTransaction, "Pendente");
        }
    endif;

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'removePerfil') {
        $id = (int) PT_Secure($_POST['id']);
        if (isset($id)) {
            $delete = $db->where('id', $id)->delete('ws_users_instagram');
            if ($delete) {
                $delete_medias = $db->where('user_instagram_id', $id)->delete('ws_medias');
                if ($delete_medias) {
                    $data = array('status' => 200, 'id' => $id);
                } else {
                    $data = array('status' => 300);
                }
            }
        }
        echo json_encode($data);
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'addLike') {
        $media_id = PT_Secure($_POST['media_id']);
        //$instagram = new \InstagramScraper\Instagram();
        $instagram = \InstagramScraper\Instagram::withCredentials('alissonmatosmaciel', 'nameiswhat1504', $_SERVER['DOCUMENT_ROOT'] . '/uploads');
        //$instagram->login();
        echo '<pre>';
        var_dump($instagram);
        echo '</pre>';
        die;
        try {
            $instagram->like($media_id);
            //$instagram->unlike('1663256735663694497');
        } catch (InstagramException $ex) {
            echo $ex->getMessage();
        }
    }
}
if (isset($_SESSION['userlogin'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'credito_user') {
        $res = select_value_uniq("ws_users", "user_id", $_SESSION['userlogin']->user_id, "user_creditos");

        if ($res) {
            $data = array(
                'creditos' => $res,
                'status' => 200
            );
        } else {
            $data = array('creditos' => 0, 'status' => 200);
        }
        echo json_encode($data);
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'statusOrdem') {
        $envia = statusOrder($_POST['order_id'], $_POST['idapi'], $_POST['api_order_id']);
        if ($envia) {
            echo json_encode($envia);
        }
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'enviarOrdem') {
        $envia = EnviaOrder($_POST['order_id']);
        if ($envia != 'error') {
            echo json_encode($envia);
        } else {
            echo json_encode($envia);
        }
    }
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'enviar_likes') {
        $user_id = (int) $_SESSION['userlogin']->user_id;

        $link_post = PT_Secure($_POST['link_post']);
        $quantidade_likes = (int) PT_Secure($_POST['quantidade_likes']);
        if (empty($_POST['genero'])) {
            echo json_encode(array('status' => 300, 'msg' => 'Genero não selecionado'));
            die;
        }
        $genero = (int) PT_Secure($_POST['genero']);
        $quantidade_views = (int) PT_Secure($_POST['quantidade_views']);
        $quantidade_total = (int) PT_Secure($_POST['quantidade_total']);
        $user = UserLogado($user_id);
        if ($quantidade_total > $user->user_creditos) {
            echo json_encode(array('status' => 300, 'msg' => 'Saldo insuficiente para realizar esse pedido'));
            die;
        }
        if ($quantidade_total <= 0) {
            echo json_encode(array('status' => 300, 'msg' => 'Você deve enviar curtidas ou views pra somar um total'));
            die;
        }
        if ($link_post == "") {
            echo json_encode(array('status' => 300, 'msg' => 'Nenhum link informado'));
            die;
        }
        if ($genero == 1) {
            $id_genero = $pt->config->config_servico_api_curtidas;
        } elseif ($genero == 2) {
            $id_genero = $pt->config->config_servico_api_curtidas_masculino;
        } elseif ($genero == 3) {
            $id_genero = $pt->config->config_servico_api_curtidas_feminino;
        }

        $subtrai = SubtraiSaldo($user_id, $quantidade_total);
        if ($subtrai == true) {
            if (!empty($quantidade_views) && $quantidade_views > 0) {
                $array = array(
                    'order_link' => $link_post,
                    'order_quantidade' => $quantidade_views,
                    'order_valor' => $quantidade_views,
                    'order_name' => $pt->config->config_api_category_views,
                    'order_service_id' => $pt->config->config_servico_api_views,
                    'order_user_id' => $user_id,
                    'order_status' => 'PENDING',
                    'order_id_api' => $pt->config->config_api_fornecedor_views,
                    'updated_at' => date('Y-m-d H:i:s'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'order_category' => $pt->config->config_api_category_views,
                    'order_type' => 'views',
                );
                $insertViews = $db->insert("ws_ordens", $array);
                EnviaOrder($insertViews);
            }
            if (!empty($quantidade_likes) && $quantidade_likes > 0) {
                $array = array(
                    'order_link' => $link_post,
                    'order_quantidade' => $quantidade_likes,
                    'order_valor' => $quantidade_likes,
                    'order_name' => $pt->config->config_api_category_curtidas,
                    'order_service_id' => $id_genero,
                    'order_user_id' => $user_id,
                    'order_status' => 'PENDING',
                    'order_id_api' => $pt->config->config_api_fornecedor_curtidas,
                    'updated_at' => date('Y-m-d H:i:s'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'order_category' => $pt->config->config_api_category_curtidas,
                    'order_type' => 'likes',
                );
                $insertLikes = $db->insert("ws_ordens", $array);
                EnviaOrder($insertLikes);
            }
            echo json_encode(array('status' => 200, 'msg' => 'Seu pedido foi enviado'));
        } else {
            echo json_encode(array('status' => 300, 'msg' => 'Erro ao enviar pedido'));
        }
    }
}
if (isset($_SESSION['userlogin'])) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'instagram_username') {
        $instagram = new \InstagramScraper\Instagram();
        if (isset($_SESSION['username_instagram'])) {
            $result_data_insta = list_perfil_instagram_username($_SESSION['username_instagram']);
        } else {
            $result_data_insta = list_perfil_instagram($_SESSION['userlogin']->user_id, 'ASC');
        }

        if ($result_data_insta) {
            $username = UsuarioInstagram(PT_Secure($result_data_insta->username));
            $vetor = ListMedias($username, $result_data_insta->id);
            if ($vetor == true) {
                $vetor = $vetor;
            } else {
                $vetor['status'] = 300;
            }
            setMedias($result_data_insta->username, $result_data_insta->id, 1000);
        } else {
            $vetor['status'] = 300;
            $vetor['user_id'] = $_SESSION['userlogin']->user_id;
        }
        echo json_encode($vetor);
    }
}

if (isset($_SESSION['userloginAdmin']) || isset($_SESSION['userlogin'])) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'suspende_ativa') {
        $codigo = filter_input(INPUT_POST, 'id_assinatura', FILTER_SANITIZE_STRING);
        $retorno = json_decode(suspenderAtivarAssinatura($codigo, $_POST['status']));
        if (isset($retorno->error)) {
            echo json_encode($retorno);
        } else {
            $update = $db->where('code', $codigo)->update('ws_assinaturas', array('status' => $_POST['status']));
            echo json_encode([
                'status' => 'ok'
            ]);
        }
    }
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['acao']) && $_POST['acao'] == 'cancelar') {
        $codigo = filter_input(INPUT_POST, 'id_assinatura', FILTER_SANITIZE_STRING);
        $retorno = json_decode(cancelar($codigo));
        if (isset($retorno->error)) {
            echo json_encode($retorno);
        } else {
            $update = $db->where('code', $codigo)->update('ws_assinaturas', array('status' => 'CANCELLED'));
            echo json_encode([
                'status' => 'ok'
            ]);
        }
    }

    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);

    if (isset($post['acao']) && $post['acao'] == 'enviar_email'):
        global $logomarcaAdmin;
        unset($post['acao']);
        $post['msg_assunto'] = utf8_decode($post['msg_assunto']);
        $name = utf8_decode($post['msg_name']);
        $msg_mensagem = utf8_decode($post['msg_mensagem']);
        $Contato['mensagem'] = "Nome: {$name}<br>E-mail: {$post['msg_email']}<br>Telefone: {$post['msg_telefone']}<br>Assunto: {$post['msg_assunto']}<br>Mensagem: {$msg_mensagem}<br>";

        /* mensagem para o admministrador do site */
        $Template = new TemplateEmail("Contato do site " . SITENAME, $Contato['mensagem'], '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', PT_Link($logomarcaAdmin));

        $Mensagem = $Template->Template();
        $enviaEmail = new enviaEmail(MAILUSER, "Assunto: {$post['msg_assunto']}", $Mensagem, $post['msg_email'], $name);
        $enviaEmail->enviar();

        /* fim da mensagem para o administrador do site */

        /* mensagem de retorno para o usuario que solicitou contato */
        $Template = new TemplateEmailRetorno("E-mail do site " . SITENAME, "Olá {$name},<br>Recebemos sua mensagem e o mais breve possível atenderemos sua solicitação. ;-)<br><br>Equipe " . SITENAME . "<br>", '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', PT_Link($logomarcaAdmin));

        $Mensagem = $Template->Template();
        $enviaEmail = new enviaEmail($post['msg_email'], "RES: Assunto: {$post['msg_assunto']}", $Mensagem, MAILUSER, SITENAME);
        $enviaEmail->enviar();

        /* fim da mensagem de retorno para o usuario que solicitou contato */
        $Dados = array();
        $Dados['msg_name'] = $post['msg_name'];
        $Dados['rand'] = $rand;
        $Dados['msg_assunto'] = $post['msg_assunto'];
        $Dados['msg_email'] = $post['msg_email'];
        $Dados['msg_mensagem'] = $Contato['mensagem'];
        $Dados['msg_telefone'] = $post['msg_telefone'];
        $Dados['msg_date'] = date('Y-m-d H:i:s');
        $Dados['msg_status'] = 0;
        $cadastra = new Create;
        $cadastra->ExeCreate("ws_mensagens", $Dados);
        if ($cadastra->getResult()):
           echo Funcoes::json(['status'=>200,'msg'=>'E-mail enviado com sucesso!']);
        else:
            echo Funcoes::json(['status'=>300,'msg'=>'Erro ao tentar enviar e-mail!']);
        endif;

    endif;

    if (isset($post['acao']) && $post['acao'] == 'enviar_email_aviseme'):
        unset($post['acao']);
        $read = new Read;
        $read->ExeRead("ws_posts", "where post_id = :id", "id={$post['msg_mensagem']}");
        if ($read->getResult()):
            $titulo = utf8_decode($read->getResult()[0]->post_title);
            $msg = "Estou interessado no jogo: {$titulo}, favor me avisar quando estiver disponivel em estoque.";
        endif;
        $post['msg_assunto'] = utf8_decode($post['msg_assunto']);
        $name = utf8_decode($post['msg_name']);
        $Contato['mensagem'] = "Nome: {$name}<br>E-mail: {$post['msg_email']}<br>Telefone: {$post['msg_telefone']}<br>Assunto: {$post['msg_assunto']}<br>Mensagem: {$msg}<br>";

        /* mensagem para o admministrador do site */
        $Template = new TemplateEmail("Contato do site " . SITENAME, $Contato['mensagem'], '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/" target="_blank" style="color: #5b9bd1; text-decoration: none;">JOGOS</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" />&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', PT_Link($logomarcaAdmin));

        $Mensagem = $Template->Template();
        $enviaEmail = new enviaEmail(MAILUSER, "Mensagem (Assunto: {$post['msg_assunto']})", $Mensagem, $post['msg_email'], $name);
        $enviaEmail->enviar();

        /* fim da mensagem para o administrador do site */

        /* mensagem de retorno para o usuario que solicitou contato */
        $Template = new TemplateEmailRetorno("E-mail do site " . SITENAME, "Olá {$name},<br>Quando o jogo {$titulo}, estiver disponivel, com certeza iremos te avisar, aguarde nosso contato.<br><br>Equipe " . SITENAME . "<br>", '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/" target="_blank" style="color: #5b9bd1; text-decoration: none;">JOGOS</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . INCLUDE_PATH . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" />&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', PT_Link($logomarcaAdmin));

        $Mensagem = $Template->Template();
        $enviaEmail = new enviaEmail($post['msg_email'], "RES: Mensagem (Assunto: {$post['msg_assunto']})", $Mensagem, MAILUSER, SITENAME);
        $enviaEmail->enviar();

        /* fim da mensagem de retorno para o usuario que solicitou contato */
        echo 1;
    endif;

    if (isset($post['post_author'])):
        $read->ExeRead("ws_users", "where user_id = :author", "author={$post['post_author']}");
        if ($read->getResult()):
            $userlogin = $read->getResult()[0];
        endif;
    endif;
    if (isset($post['acao']) && $post['acao'] == 'enviar_modal') {
        $ArrOnlone = [
            'modal' => 1
        ];
        $update = new Update;
        $update->ExeUpdate('ws_siteviews_online', $ArrOnlone, "WHERE online_session = :ses", "ses={$_SESSION['useronline']['online_session']}");
    }
    if (isset($post['acao']) && $post['acao'] == 'publicar_min') {
        unset($post['acao']);
        $read->ExeRead("ws_posts", "where post_id = :id", "id={$post['post_id']}");
        if ($read->getResult()):
            $pos = $read->getResult()[0];
        endif;
        if (isset($post['id'])):
            $update->ExeUpdate("ws_posts_meta", $post, "where id = :idi", "idi={$post['id']}");
            if ($update->getResult()):
                echo $post['id'];
                $update->ExeUpdate("ws_posts", $Dados, "where post_id = :postid", "postid={$post['post_id']}");
            else:
                echo 0;
            endif;
        else:
            $cadastra->ExeCreate("ws_posts_meta", $post);
            if ($cadastra->getResult()):
                echo $cadastra->getResult();
                $update->ExeUpdate("ws_posts", $Dados, "where post_id = :postid", "postid={$post['post_id']}");
            else:
                echo 0;
            endif;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'publicar_min_saida') {
        unset($post['acao']);
        $read->ExeRead("ws_posts", "where post_id = :id", "id={$post['post_id']}");
        if ($read->getResult()):
            $pos = $read->getResult()[0];
        endif;
        $read->ExeRead("ws_posts_meta", "where id = :idi", "idi={$post['id']}");
        if ($read->getResult()):
            $posmet = $read->getResult()[0];
        endif;
        $Dados = array(
            'post_quantidade' => ($pos->post_quantidade - $post['qtd'])
        );
        if (isset($post['id'])):
            $post = array(
                'qtd' => ($post['qtd'] - $posmet->qtd)
            );
            $update->ExeUpdate("ws_posts_meta", $post, "where id = :idi", "idi={$post['id']}");
            if ($update->getResult()):
                echo $post['id'];
                $update->ExeUpdate("ws_posts", $Dados, "where post_id = :postid", "postid={$pos->post_id}");
            else:
                echo 0;
            endif;
        else:
            $cadastra->ExeCreate("ws_posts_meta", $post);
            if ($cadastra->getResult()):
                echo $cadastra->getResult();
                $update->ExeUpdate("ws_posts", $Dados, "where post_id = :postid", "postid={$pos->post_id}");
            else:
                echo 0;
            endif;
        endif;
    }
    if (isset($post['acao']) && $post['acao'] == 'publicar') {
        if (!empty($_FILES['post_cover']['tmp_name'])):
            $post['post_cover'] = $_FILES['post_cover'];
        else:
            $post['post_cover'] = null;
        endif;
        if (isset($post['post_content'])):
            $post['post_content'] = trim($post['post_content']);
        endif;
        unset($post['acao']);
        $post['post_name'] = $check->Name($post['post_title']);
        $post['post_date'] = $check->Data($post['post_date']);
        $Where = (isset($post['post_id']) ? "post_id != {$post['post_id']} AND" : '');
        $read->ExeRead("ws_posts", "WHERE {$Where} post_title = :t", "t={$post['post_title']}");
        if ($read->getResult()):
            $post['post_name'] = $post['post_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        if ($post['post_cover']):
            $upload->Image($post['post_cover'], $post['post_name'] . '-' . uniqid() . time(), $post['post_tamanho'], $post['post_type']);
        endif;

        if (isset($upload) && $upload->getResult()):
            $post['post_cover'] = $upload->getResult();
        else:
            $post['post_cover'] = null;
        endif;
        /* if (isset($post['post_category'])):
          $cad['post_category'] = $post['post_category'];
          unset($post['post_category']);
          endif;

          //$count = count($post); */

        unset($post['post_tamanho']);
        $cadastra->ExeCreate("ws_posts", $post);

        /* if (isset($cad['post_category'])):
          AdminPost::CadastraCategoriaTag($cad['post_category'], $cadastra->getResult(), $post['post_type']);
          endif; */


        if ($cadastra->getResult()):
            $id = $cadastra->getResult();
            echo $id;
        else:
            echo 0;
        endif;
    }

    /* editar posts */
    if (isset($post['acao']) && $post['acao'] == 'publicar_edit') {
        if (isset($_FILES['post_cover']['tmp_name'])):
            $post['post_cover'] = $_FILES['post_cover'];
        else:
            $post['post_cover'] = 'null';
        endif;

        if (isset($post['post_content'])):
            $post['post_content'] = trim($post['post_content']);
        endif;
        unset($post['acao']);

        $post['post_name'] = $check->Name($post['post_title']);
        $post['post_date'] = $check->Data($post['post_date']);

        $Where = (isset($post['post_id']) ? "post_id != {$post['post_id']} AND" : '');

        $read->ExeRead("ws_posts", "WHERE {$Where} post_title = :t", "t={$post['post_title']}");
        if ($read->getResult()):
            $post['post_name'] = $post['post_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        if (is_array($post['post_cover'])):
            $read->ExeRead("ws_posts", "WHERE post_id = :post", "post={$post['post_id']}");
            $capa = $_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $read->getResult()[0]->post_cover;
            $upload->Image($post['post_cover'], $post['post_name'] . '_' . uniqid() . time(), $post['post_tamanho'], $post['post_type']);
        endif;

        if (isset($post['post_cover']['tmp_name']) && $upload->getResult()):
            $post['post_cover'] = $upload->getResult();
        else:
            $post['post_cover'] = null;
            unset($post['post_cover']);
        endif;
        /* if (isset($post['post_category'])):
          $cad['post_category'] = $post['post_category'];
          unset($post['post_category']);
          endif; */

        unset($post['post_tamanho']);

        $update->ExeUpdate("ws_posts", $post, "where post_id = :id", "id={$post['post_id']}");

        /* if (isset($cad['post_category'])):
          AdminPost::CadastraCategoriaTag($cad['post_category'], $post['post_id'], $post['post_type']);
          endif; */

        if ($update->getResult()):
            echo $post['post_id'];
        else:
            echo 0;
        endif;
    }
    /* fim editar posts */

    /* categorias */

    if (isset($post['acao']) && $post['acao'] == 'publicar_categoria') {
        $post['category_img'] = ( $_FILES['category_img']['tmp_name'] ? $_FILES['category_img'] : null );
        $post['category_content'] = trim($post['category_content']);
        unset($post['acao']);

        $post['category_name'] = $check->Name($post['category_title']);
        $post['category_date'] = $check->Data($post['category_date']);


        $Where = (isset($post['category_id']) ? "category_id != {$post['category_id']} AND" : '');
        $read->ExeRead("ws_categories", "WHERE {$Where} category_title = :t", "t={$post['category_title']}");
        if ($read->getResult()):
            $post['category_name'] = $post['category_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        if ($post['category_img']):
            $upload->Image($post['category_img'], $post['category_name'] . '-' . uniqid(), 800, $post['category_type']);
        endif;

        if (isset($upload) && $upload->getResult()):
            $post['category_img'] = $upload->getResult();
        else:
            $post['category_img'] = null;
        endif;
        $cadastra->ExeCreate("ws_categories", $post);

        if ($cadastra->getResult()):
            echo $cadastra->getResult();
        else:
            echo 0;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'publicar_fornecedor') {
        unset($post['acao']);

        $post['fornecedor_name'] = $check->Name($post['fornecedor_title']);
        $post['fornecedor_date'] = $check->Data($post['fornecedor_date']);


        $Where = (isset($post['fornecedor_id']) ? "fornecedor_id != {$post['category_id']} AND" : '');
        $read->ExeRead("ws_fornecedores", "WHERE {$Where} fornecedor_title = :t", "t={$post['fornecedor_title']}");
        if ($read->getResult()):
            $post['fornecedor_name'] = $post['fornecedor_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        $cadastra->ExeCreate("ws_fornecedores", $post);

        if ($cadastra->getResult()):
            echo $cadastra->getResult();
        else:
            echo 0;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'publicar_categoria_edit') {
        $post['category_img'] = ($_FILES['category_img']['tmp_name']) ? $_FILES['category_img'] : null;
        if (isset($_FILES['category_img']['tmp_name'])):
            $post['category_img'] = $_FILES['category_img'];
        else:
            $post['category_img'] = 'null';
        endif;

        $post['category_content'] = trim($post['category_content']);
        unset($post['acao']);

        $post['category_name'] = $check->Name($post['category_title']);

        $Where = (isset($post['category_id']) ? "category_id != {$post['category_id']} AND" : '');

        $read->ExeRead("ws_categories", "WHERE {$Where} category_title = :t", "t={$post['category_title']}");
        if ($read->getResult()):
            $post['category_name'] = $post['category_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        if (is_array($post['category_img'])):
            $read->ExeRead("ws_categories", "WHERE category_id = :post", "post={$post['category_id']}");
            $capa = $_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $read->getResult()[0]->category_img;
            $upload->Image($post['category_img'], $post['category_name'] . '_' . uniqid(), 800, $post['category_type']);
        endif;

        if (isset($post['category_img']['tmp_name']) && $upload->getResult()):
            $post['category_img'] = $upload->getResult();
        else:
            $post['category_img'] = null;
            unset($post['category_img']);
        endif;

        $update->ExeUpdate("ws_categories", $post, "where category_id = :id", "id={$post['category_id']}");

        if ($update->getResult()):
            echo $post['category_id'];
        else:
            echo 0;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'publicar_fornecedor_edit') {

        unset($post['acao']);

        $post['fornecedor_name'] = $check->Name($post['fornecedor_title']);

        $Where = (isset($post['fornecedor_id']) ? "fornecedor_id != {$post['fornecedor_id']} AND" : '');

        $read->ExeRead("ws_fornecedores", "WHERE {$Where} fornecedor_title = :t", "t={$post['fornecedor_title']}");
        if ($read->getResult()):
            $post['fornecedor_name'] = $post['fornecedor_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        $update->ExeUpdate("ws_fornecedores", $post, "where fornecedor_id = :id", "id={$post['fornecedor_id']}");

        if ($update->getResult()):
            echo $post['fornecedor_id'];
        else:
            echo 0;
        endif;
    }

    /* fim de categorias */

    if (isset($_POST['acao']) && $_POST['acao'] == 'enviar_desc') {
        $Dados['post_content'] = $_POST['post_content'];

        $update->ExeUpdate("ws_posts", $Dados, "where post_id = :id", "id={$_POST['post_id']}");
        if ($update->getResult()):
            echo $_POST['post_id'];
        else:
            echo 0;
        endif;
    }
    if (isset($_POST['acao_remover']) && $_POST['acao_remover'] == 'remover_post'):
        $read->ExeRead("ws_posts", "where post_id = :id", "id={$_POST['id']}");
        if ($read->getResult()):
            $remove = new Delete;
            $remove->ExeDelete("ws_posts", "where post_type = :type and post_id = :id", "type={$_POST['type']}&id={$_POST['id']}");
            if ($remove->getResult()):
                if (file_exists($_SERVER['DOCUMENTO_ROOT'] . '/uploads/' . $read->getResult()[0]->post_cover) && !is_dir($_SERVER['DOCUMENTO_ROOT'] . '/uploads/' . $read->getResult()[0]->post_cover)):
                    unlink($_SERVER['DOCUMENTO_ROOT'] . '/uploads/' . $read->getResult()[0]->post_cover);
                endif;
                echo 1;
            else:
                echo 0;
            endif;

        endif;

    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_pedido'):
        $remove = new Delete;
        $remove->ExeDelete("ws_pedidos", "where pedido_id = :id", "id={$_POST['id']}");
        if ($remove->getResult()):
            echo 1;
        else:
            echo 0;
        endif;

    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_categoria'):
        $remove = new AdminCategory();
        $remove->ExeDelete($_POST['id']);
        if ($remove->getResult()):
            echo 1;
        else:
            echo 0;
        endif;

    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_fornecedor'):
        $remove = new AdminFornecedor();
        $remove->ExeDelete($_POST['id']);
        if ($remove->getResult()):
            echo 1;
        else:
            echo 0;
        endif;

    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_capa'):

        $Dados['post_cover'] = 'null';

        $read->ExeRead("ws_posts", "WHERE post_id = :post", "post={$_POST['post_id']}");

        if ($read->getResult()):

            $capa = $_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $read->getResult()[0]->post_cover;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;
            $update->ExeUpdate("ws_posts", $Dados, "where post_id = :id", "id={$_POST['post_id']}");

            echo 1;
        else:
            echo 0;
        endif;

    endif;

    if (isset($_GET['acao']) && $_GET['acao'] == 'list_galeria'):
        $read->ExeRead("ws_posts", "where post_id = :post", "post={$_GET['post_id']}");
        if ($read->getResult()):
            $post = $read->getResult()[0];

            $read->ExeRead("ws_posts_gallery", "where post_id = :id", "id={$_GET['post_id']}");
            if ($read->getResult()):
                foreach ($read->getResult() as $gallery_event):
                    if ($post->post_cover == $gallery_event->gallery_image):
                        $border = 'border:3px solid red;';
                    else:
                        $border = '';
                    endif;
                    echo "<div class=\"col-sm-4\" style=\"margin-bottom:10px;{$border}\">
            <img style=\"border:2px dotted red;\" src=\"{$base}/uploads/{$gallery_event->gallery_image}\" class=\"img-responsive\" alt=\"\"/>
            <a href=\"javascript:func()\" onclick=\"confirmacao('{$gallery_event->gallery_id}')\" class=\"btn btn-block btn-flat btn-danger btn-xs\"><i class=\"fa fa-trash\"></i> Deletar</a>
            </div>";

                endforeach;
            else:
            endif;

        endif;
    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'deletar_galeria'):

        $read->ExeRead("ws_posts_gallery", "WHERE post_id = :id AND gallery_id = :idga", "id={$_POST['post_id']}&idga={$_POST['gallery_id']}");
        if ($read->getResult()):
            foreach ($read->getResult() as $gbdel):
                if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $gbdel->gallery_image) && !is_dir($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $gbdel->gallery_image)):
                    unlink($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $gbdel->gallery_image);
                endif;
            endforeach;
        endif;

        $delete->ExeDelete("ws_posts_gallery", "where gallery_id = :idg", "idg={$_POST['gallery_id']}");
        if ($delete->getResult()):
            echo $_POST['post_id'];
        else:
            echo 0;
        endif;
    endif;


    if (isset($_POST['acao']) && $_POST['acao'] == 'recuperar_categorias'):

        $id = $_POST['id'];
        $read = new Read;
        $read->ExeRead("ws_term_taxonomy", "where term_id = :id", "id={$id}");

        if ($read->getRowCount() > 0) {
            foreach ($read->getResult() as $dados) {
                $cat = $db->where('term_id', $dados->term_id)->getOne('ws_terms');
                $dados->slug = $cat->slug;
                $json = $dados;
            }
        }

        echo json_encode($json);

    endif;

    if (isset($_POST['acao']) && $_POST['acao'] == 'recuperar_posts'):

        $id = $_POST['id'];
        $read = new Read;
        $read->ExeRead("ws_posts", "where post_id = :id", "id={$id}");

        if ($read->getRowCount() > 0) {
            foreach ($read->getResult() as $dados) {
                $json = $dados;
            }
        }

        echo json_encode($json);

    endif;

    /* config editar */
    if (isset($post['acao']) && $post['acao'] == 'publicar_config') {
        $post['config_logo'] = ($_FILES['config_logo']['tmp_name']) ? $_FILES['config_logo'] : null;
        if (isset($_FILES['config_logo']['tmp_name'])):
            $post['config_logo'] = $_FILES['config_logo'];
        else:
            $post['config_logo'] = 'null';
        endif;

        $post['config_description'] = trim($post['config_description']);
        unset($post['acao']);

        $post['config_name'] = $check->Name($post['config_title']);

        $Where = (isset($post['config_id']) ? "config_id != {$post['config_id']} AND" : '');

        $read->ExeRead("ws_config", "WHERE {$Where} config_title = :t", "t={$post['config_title']}");
        if ($read->getResult()):
            $post['config_name'] = $post['config_name'] . '-' . $read->getRowCount();
        endif;

        function limpaIMG($valor) {
            $valor = trim($valor);
            $valor = str_replace(",", "_.", $valor);
            $valor = str_replace("/", "_.", $valor);
            $valor = str_replace("(", "_.", $valor);
            $valor = str_replace(")", "_.", $valor);
            $valor = str_replace("%", "_.", $valor);
            $valor = str_replace("*", "_.", $valor);
            $valor = str_replace("&", "_.", $valor);
            $valor = str_replace("¨", "_.", $valor);
            $valor = str_replace("$", "_.", $valor);
            $valor = str_replace("#", "_.", $valor);
            $valor = str_replace("@", "_.", $valor);
            $valor = str_replace("!", "_.", $valor);
            $valor = str_replace(" ", "_.", $valor);
            return $valor;
        }

        if (is_array($post['config_logo'])):
            $read->ExeRead("ws_config", "WHERE config_id = :post", "post={$post['config_id']}");
            $capa = $_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $read->getResult()[0]->config_logo;
            $upload->Image($post['config_logo'], $post['config_name'] . '_' . uniqid(), 300, 'logo');
        endif;

        if (isset($post['config_logo']['tmp_name']) && $upload->getResult()):
            $post['config_logo'] = $upload->getResult();
        else:
            $post['config_logo'] = null;
            unset($post['config_logo']);
        endif;

        unset($post['config_name']);
        $update->ExeUpdate("ws_config", $post, "where config_id = :id", "id={$post['config_id']}");

        if ($update->getResult()):
            echo $post['config_id'];
        else:
            echo 0;
        endif;
    }
    /* fim config editar */

    /* login */
    if (isset($_POST['action_reset']) && $_POST['action_reset'] == 'recuperar_senha') {
        if (PHP_OS == "Linux")
            $quebra_linha = "\n";
        elseif (PHP_OS == "WINNT")
            $quebra_linha = "\r\n";


        $read->ExeRead("ws_users", "where user_email = :email", "email={$_POST['email']}");
        if ($read->getResult()):
            $user = $read->getResult()[0];
            $Dados['user_password'] = md5('123456');

            $update = new Update();
            $update->ExeUpdate("ws_users", $Dados, "where user_email = :mail", "mail={$_POST['email']}");
            if ($update->getResult()):
                echo 1;
                $Contato['mensagem'] = "Nome: {$user->user_name}<br>"
                        . "E-mail: {$user->user_email}<br>"
                        . "Nova senha: 123456<br>"
                        . "Solicitamos que ao realizar o login com esses dados, você troque a sua senha para melhorar a segurança do painel!";
                $Contato2['mensagem'] = "O usuário {$user->user_name}, acaba de redefinir a senha no nosso painel";

                $Template = new TemplateEmail("Notificação de alteração de senha " . SITENAME, $Contato2['mensagem'], '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . CAMINHO_ADMIN . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/exames" target="_blank" style="color: #5b9bd1; text-decoration: none;">EXAMES</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . CAMINHO_ADMIN . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" />&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $etConfig->config_logo);

                $Mensagem = $Template->Template();
                $enviaEmail = new enviaEmail(MAILUSER, "Notificação de alteração de senha: " . SITENAME, $Mensagem, $user->user_email, $user->user_name);
                $enviaEmail->enviar();

                /* fim da mensagem para o administrador do site */

                /* mensagem de retorno para o usuario que solicitou contato */
                $Template = new TemplateEmailRetorno("Redefinição de senha no site: " . SITENAME, "Olá {$user->user_name},<br>Verificamos que você solicitou uma nova senha no nosso sistema.<br><br><strong>Segue abaixo sua nova senha:</strong><br>{$Contato['mensagem']}<br><br>Equipe " . SITENAME . "<br>", '<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #5b9bd1;">
                                                                                        <a href="' . BASE . '" target="_blank" style="color: #5b9bd1; text-decoration: none;">HOME</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . CAMINHO_ADMIN . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" /></a>&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/exames" target="_blank" style="color: #5b9bd1; text-decoration: none;">EXAMES</a>
                                                                                        &nbsp;&nbsp;&nbsp;&nbsp;<img src="' . CAMINHO_ADMIN . '/images/dot.gif" alt="|" width="6" height="9" class="mob_display_none" />&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                        <a href="' . $base . '/contato" target="_blank" style="color: #5b9bd1; text-decoration: none;">CONTATO</a>
                                                                                    </span>', $etConfig->config_logo);

                $enviaEmail = new enviaEmail($user->user_email, "Redefinição de senha no site: " . SITENAME, $Mensagem, MAILUSER, SITENAME);
                $enviaEmail->enviar();

            else:
                echo 0;
            endif;
        else:
            echo 2;
        endif;
    }
    if (isset($_POST['action']) && $_POST['action'] == 'login') {
        $login = new LoginAdmin(4);

        $dataLogin['user'] = filter_input(INPUT_POST, 'usuario', FILTER_DEFAULT);
        $dataLogin['pass'] = filter_input(INPUT_POST, 'senha', FILTER_DEFAULT);

        $login->ExeLogin($dataLogin);
        if (!$login->getResult()):
            echo WLMsg($login->getError()[0], $login->getError()[1]);
        else:
            echo 1;
        endif;


        $get = filter_input(INPUT_GET, 'exe', FILTER_DEFAULT);
        if (!empty($get)):
            if ($get == 'restrito'):
                WLMsg('<b>Oppsss:</b> Acesso negado. Favor efetue login para acessar o painel!', WS_ALERT);
            elseif ($get == 'logoff'):
                WLMsg('<b>Sucesso ao deslogar:</b> Sua sessão foi finalizada. Volte sempre!', WS_ACCEPT);
            endif;

        endif;
    }

    /* fim de login */

    /* fim de login */

    /* usuarios */

    if (isset($post['acao']) && $post['acao'] == 'publicar_usuario') {
        unset($post['acao']);
        $check = new Check;
        $post['user_registration'] = $check->Data($post['user_registration']);
        $cadastra = new AdminUser();
        $cadastra->ExeCreate($post);
        if ($cadastra->getResult()):
            echo $cadastra->getResult();
        else:
            echo 0;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'editar_usuario') {
        $id = $post['user_id'];
        unset($post['acao']);
        $post['user_lastupdate'] = $check->Data($post['user_lastupdate']);
        $cadastra = new AdminUser();
        $cadastra->ExeUpdate($id, $post);
        if ($cadastra->getResult()):
            echo $id;
        else:
            echo 0;
        endif;
    }

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_user'):
        $remove = new AdminUser;
        $remove->ExeDelete($_POST['id']);
        if ($remove->getResult()):
            echo 1;
        else:
            echo 0;
        endif;

    endif;

    /* fim de usuarios */

    /* salvar_menu */
    if (isset($post['acao']) && $post['acao'] == 'salvar_menu') {
        unset($post['acao']);
        $id = (int) $post['id'];
        $Dados['backend_json'] = $post['json'];

        if (empty($id)):
            $cadastra = new Create();
            $cadastra->ExeCreate("ws_menu", $Dados);
            if ($cadastra->getResult()):
                echo $cadastra->getResult();
            else:
                echo 0;
            endif;
        else:
            $update = new Update();
            $update->ExeUpdate("ws_menu", $Dados, "where id = :id", "id={$id}");
            if ($update->getResult()):
                echo $id;
            else:
                echo 0;
            endif;
        endif;
    }

    if (isset($post['acao']) && $post['acao'] == 'listar_menu') {
        unset($post['acao']);
        $read = new Read;
        $read->ExeRead("ws_menu");
        if ($read->getResult()):
            echo json_encode($read->getResult()[0]);
        else:
            echo 0;
        endif;
    }
    /* fim de salvar_menu */
    if (isset($post['acao']) && $post['acao'] == 'listar_item') {
        unset($post['acao']);
        $read = new Read;
        $read->ExeRead("ws_posts_meta", "where id = :id", "id={$post['id_editar']}");
        if ($read->getResult()):
            echo json_encode($read->getResult()[0]);
        else:
            echo 0;
        endif;
    }

    if (isset($_POST['acao']) && $_POST['acao'] == 'remover_item_produto'):
        $remove = new Delete;
        $remove->ExeDelete("ws_posts_meta", "where id = :id", "id={$_POST['id']}");
        if ($remove->getResult()):
            echo 1;
        else:
            echo 0;
        endif;

    endif;
}
if (!empty($_POST['acao']) && $_POST['acao'] == 'pagar') {
    if (!empty($_POST['payment_method']) && $_POST['payment_method'] == 'credit_card') {
        if (isset($_POST['type']) && $_POST['type'] == 'assinatura') {
            $date = new DateTime();
            $date->setTimezone(new \DateTimeZone('UTC'));
            $date->add(new DateInterval('P1M'));
            $dataFinal = $date->format('Y-m-d\T00:00:00\0-03:00');
            $reference = time();
            $_SESSION['userlogin']->user_cep = PT_limpaCPF_CNPJ($_SESSION['userlogin']->user_cep);

            $update_user = $db->where('user_id', $_SESSION['userlogin']->user_id)->update('ws_users', array('user_nascimento' => PT_Nascimento($_POST['nascimento']), 'user_cpf' => $_POST['cpfs'], 'user_phone' => $_POST['cels'], 'user_cel' => $_POST['cels']));

            if (isset($_SESSION['userlogin']->user_cep) && $_SESSION['userlogin']->user_cep != '') {
                $cep = $_SESSION['userlogin']->user_cep;
                $nomeCompleto = $_SESSION['userlogin']->user_name . ' ' . $_SESSION['userlogin']->user_lastname;
                $rua = $_SESSION['userlogin']->user_endereco;
                $numero = $_SESSION['userlogin']->user_numero;
                $complemento = $_SESSION['userlogin']->user_complemento;
                $bairro = $_SESSION['userlogin']->user_bairro;
                $cidade = $_SESSION['userlogin']->user_city;
                $estado = $_SESSION['userlogin']->user_uf;
                $pais = $_SESSION['userlogin']->user_pais;
            }

            $datas = [
                'plan' => PT_limpaCPF_CNPJ(PT_Secure($_POST['plano'])),
                'reference' => $reference,
                'sender' => [
                    'name' => $nomeCompleto,
                    'email' => $_SESSION['userlogin']->user_email,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'hash' => PT_Secure($_POST['hash']),
                    'phone' => [
                        'areaCode' => DDD($_POST['cels']),
                        'number' => FONE($_POST['cels'])
                    ],
                    'address' => [
                        "street" => "{$rua}",
                        "number" => "{$numero}",
                        "complement" => "{$complemento}",
                        "district" => "{$bairro}",
                        "city" => "{$cidade}",
                        "state" => strtoupper($estado),
                        "country" => substr($pais, 0, 3),
                        "postalCode" => PT_limpaCPF_CNPJ($cep)
                    ],
                    'documents' => array([
                            "type" => "CPF",
                            "value" => PT_limpaCPF_CNPJ($_POST['cpfs'])
                        ])
                ],
                "paymentMethod" => [
                    'type' => 'CREDITCARD',
                    'creditCard' => [
                        'token' => PT_Secure($_POST['token']),
                        'holder' => [
                            'name' => PT_Secure($_POST['ccname']),
                            'birthDate' => PT_Secure($_POST['nascimento']),
                            "documents" => array([
                                    "type" => "CPF",
                                    "value" => PT_limpaCPF_CNPJ($_POST['cpfs'])
                                ]),
                            "billingAddress" => [
                                "street" => "{$rua}",
                                "number" => "{$numero}",
                                "complement" => "{$complemento}",
                                "district" => "{$bairro}",
                                "city" => "{$cidade}",
                                "state" => "{$estado}",
                                "country" => substr($pais, 0, 3),
                                "postalCode" => PT_limpaCPF_CNPJ($cep)
                            ],
                            "phone" => [
                                'areaCode' => DDD($_POST['cels']),
                                'number' => FONE($_POST['cels'])
                            ]
                        ]
                    ]
                ]
            ];

            $assinar = json_decode(assinarPagseguro($datas));

            $db->where('post_status', 1);
            $db->where('post_id', PT_Secure($_POST['plano_id']));
            $get_planos = $db->getOne('ws_posts');
            $get_planos = (object) $get_planos;
            if (isset($assinar->error)) {
                $data['status'] = 300;
                $data = $assinar;
            } else {
                if (isset($_SESSION['t'])) {
                    $post_valor = $_SESSION['t'];
                    $vDesconto = $_SESSION['desconto'];
                } else {
                    $post_valor = $get_planos->post_valor;
                    $vDesconto = 0;
                }
                $insert_data = array(
                    'code' => $assinar->code,
                    'amount' => $post_valor,
                    'plan_code' => PT_Secure($_POST['plano']),
                    'plan_id' => PT_Secure($_POST['plano_id']),
                    'payment_method' => strtoupper('credit_card'),
                    'customer_code' => $_SESSION['userlogin']->user_id,
                    'customer_id' => $_SESSION['userlogin']->user_id,
                    'customer_email' => $_SESSION['userlogin']->user_email,
                    'customer_fullname' => $nomeCompleto,
                    'customer_cpf' => $_POST['cpfs'],
                    'customer_nascimento' => PT_Nascimento($_POST['nascimento']),
                    'customer_address_street' => $rua,
                    'customer_address_number' => $numero,
                    'customer_address_complement' => $complemento,
                    'customer_address_district' => $bairro,
                    'customer_address_city' => $cidade,
                    'customer_address_state' => $estado,
                    'customer_address_zipcode' => $cep,
                    'customer_address_country' => substr($pais, 0, 3),
                    'status' => 'PENDING',
                    'referencia' => $reference,
                    'data' => date('Y-m-d H:i:s'),
                    'id_assinatura' => $assinar->code,
                    'gateway' => 'pagseguro',
                    'desconto' => $vDesconto,
                    'proxima_fatura' => date('Y-m-d H:i:s', strtotime('+1month')),
                );

                $assinatura_id = $db->insert("ws_assinaturas", $insert_data);

                $xmlAssinatura = (object) json_decode(curl_retorno_assinatura($assinar->code), JSON_PRETTY_PRINT);

                if ($xmlAssinatura) {
                    unset($_SESSION['instagram']);
                    $data = array('status' => 200, 'sts' => $xmlAssinatura->status, 'gateway' => 'pagseguro');
                }
            }
        }
        echo json_encode($data);
    }
}
if (isset($_POST['acao']) && $_POST['acao'] == 'sessao') {

    $idSessao = idSessaoPagseguro();

    if (isset($idSessao)) {
        $data = array('status' => 200, 'id' => $idSessao->id);
    } else {
        $data = array('status' => 300, 'error' => 'ERROR');
    }
    echo json_encode($data);
}
if (!empty($_POST['acao']) && $_POST['acao'] == 'cadastrar_endereco') {
    unset($_POST['acao']);
    $update = $db->where('user_id', $_SESSION['userlogin']->user_id)->update('ws_users', $_POST);
    if ($update) {
        $data = array('status' => 200);
    } else {
        $data = array('status' => 300);
    }
    echo json_encode($data);
}
