<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
//require $_SERVER['DOCUMENT_ROOT'] . '/admin/modulos/vendor/autoload.php';
use Aws\S3\S3Client;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
function assinantes_ativos($string) {
    global $db;
    $conta = count($db->where('cartao_grupo', $string)->where('cartao_status', 'ATIVO')->get('ws_cartoes'));
   /*if ($conta <= 0) {
        return 'Nenhum assinante';
    } elseif ($conta == 1) {
        return '1 assinante';
    } elseif($conta>1) {*/
        return $conta;
   /* }*/
}
function assinantes_inativos($string) {
    global $db;
    $conta = count($db->where('cartao_grupo', $string)->where('cartao_status', 'INATIVO')->get('ws_cartoes'));
    /*if ($conta <= 0) {
        return 'Nenhum assinante';
    } elseif ($conta == 1) {
        return '1 assinante';
    } elseif($conta>1) {*/
        return $conta;
  /*  }*/
}
if (!function_exists('WSMsg')) {
    function WSMsg($ErrMsg, $ErrNo, $ErrDie = null) {
        $CssClass = ($ErrNo == E_USER_NOTICE ? WS_INFOR : ($ErrNo == E_USER_WARNING ? WS_ALERT : ($ErrNo == E_USER_ERROR ? WS_ERROR : $ErrNo)));
        echo "<div class=\"alert alert-{$CssClass}\">";
        echo "{$ErrMsg}";
        echo "</div>";
        if ($ErrDie):
            die;
        endif;
    }
}
if (!function_exists('array_diff_key_recursive')):
    function array_diff_key_recursive($a1, $a2) {
        $r = array();
        foreach ($a1 as $k => $v) {
            if (is_array($v)) {
                if (!isset($a2[$k]) || !is_array($a2[$k])) {
                    $r[$k] = $a1[$k];
                } else {
                    if ($diff = array_diff_key_recursive($a1[$k], $a2[$k])) {
                        $r[$k] = $diff;
                    }
                }
            } else {
                if (!isset($a2[$k]) || is_array($a2[$k])) {
                    $r[$k] = $v;
                }
            }
        }
        return $r;
    }
endif;
if (!function_exists('array_cast_recursive')):
    function array_cast_recursive($array) {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                if (is_array($value)) {
                    $array[$key] = array_cast_recursive($value);
                }
                if ($value instanceof stdClass) {
                    $array[$key] = array_cast_recursive((array) $value);
                }
            }
        }
        if ($array instanceof stdClass) {
            return array_cast_recursive((array) $array);
        }
        return $array;
    }
endif;
function ToObject($array) {
    $object = new stdClass();
    foreach ($array as $key => $value) {
        if (is_array($value)) {
            $value = ToObject($value);
        }
        if (isset($value)) {
            $object->$key = $value;
        }
    }
    return $object;
}
function ToArray($obj) {
    if (is_object($obj))
        $obj = (array) $obj;
    if (is_array($obj)) {
        $new = array();
        foreach ($obj as $key => $val) {
            $new[$key] = ToArray($val);
        }
    } else {
        $new = $obj;
    }
    return $new;
}
function pt_desconto($porcentagem, $total) {
    $percentual = $porcentagem / 100.0;
    return $valor_final = $total - ($percentual * $total);
}
function UserLogado($user_id = 0, $options = array()) {
    global $db, $prefix;
    if (!empty($options['data'])) {
        $fetched_data = $user_id;
    } else {
        $fetched_data = $db->where('user_id', $user_id)->getOne('ws_users');
    }
    if (empty($fetched_data)) {
        return false;
    }
    $fetched_data->user_id = $fetched_data->user_id;
    $fetched_data->user_id = $fetched_data->user_id;
    return $fetched_data;
}
function QtdOrdens($status) {
    global $db;
    $quantidade = $db->where('statusOrdem', $status)->get('tbl_ordens');
    if ($quantidade):
        $data = array(
            'conta' => count($quantidade),
            'res' => $quantidade,
        );
    else:
        $data = array(
            'conta' => 0,
        );
    endif;
    return $data;
}
function tiraMoeda($string) {
    $pontos = array(",", ".");
    $result = str_replace($pontos, "", $string);
    return $result;
}
function RemoveArroba($string) {
    $pontos = array("@");
    $result = str_replace($pontos, "", $string);
    return $result;
}
function RemoveBarra($string) {
    $pontos = array("/");
    $result = str_replace($pontos, "", $string);
    return $result;
}
function get_content($url) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "{$url}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => array(
            "Cache-Control: no-cache",
            "Content-Type: application/json"
        ),
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        return json_decode($response);
    }
}
function curl_get_contents($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
    $html = curl_exec($ch);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}
function file_get_html($url, $use_include_path = false, $context = null, $offset = -1, $maxLen = -1, $lowercase = true, $forceTagsClosed = true, $target_charset = DEFAULT_TARGET_CHARSET, $stripRN = true, $defaultBRText = DEFAULT_BR_TEXT, $defaultSpanText = DEFAULT_SPAN_TEXT) {
    $dom = new simple_html_dom;
    $args = func_get_args();
    $dom->load(call_user_func_array('curl_get_contents', $args), true);
    return $dom;
//$dom = new simple_html_dom(null, $lowercase, $forceTagsClosed, $target_charset, $stripRN, $defaultBRText, $defaultSpanText);
}
function corta_string($string = "", $inicio = 0, $tamanho = 0) {
    if (isset($tamanho) && $tamanho > 0) {
        return substr($string, $inicio, $tamanho);
    } else {
        return substr($string, $inicio);
    }
}
function conta_caracteres($string) {
    return strlen($string);
}
function escondeEmailOne($email, $qtd = 3) {
    return substr($email, 0, $qtd);
}
function escondeEmailDois($email, $qtd = 3) {
    return substr($email, -$qtd);
}
function CamuflaEmail($email) {
    $email = explode("@", $email);
    if (isset($email[0])) {
        $count = conta_caracteres($email[0]);
        $email1 = escondeEmailOne($email[0], 2);
        $email2 = escondeEmailDois($email[0], 2);
        $countOne = conta_caracteres($email1);
        $countTwo = conta_caracteres($email2);
        $totalCount = $count - ($countOne + $countTwo);
        $asteristicos = "***********************************************************";
        $total_asteristicos = substr($asteristicos, 0, $totalCount);
        return $email1 . $total_asteristicos . $email2 . "@" . $email[1];
    }
}
function PT_Secure($string, $br = true) {
    global $mysqli;
    $string = trim($string);
    $string = mysqli_real_escape_string($mysqli, $string);
    $string = htmlspecialchars($string, ENT_QUOTES);
    if ($br == true) {
        $string = str_replace('\r\n', " <br>", $string);
        $string = str_replace('\n\r', " <br>", $string);
        $string = str_replace('\r', " <br>", $string);
        $string = str_replace('\n', " <br>", $string);
    } else {
        $string = str_replace('\r\n', "", $string);
        $string = str_replace('\n\r', "", $string);
        $string = str_replace('\r', "", $string);
        $string = str_replace('\n', "", $string);
    }
    $string = stripslashes($string);
    $string = str_replace('&amp;#', '&#', $string);
    $string = preg_replace("/{{(.*?)}}/", '', $string);
    return $string;
}
function gera_hash($string) {
    $options = [
        'cost' => 11,
        'salt' => mcrypt_create_iv(22, MCRYPT_DEV_URANDOM),
    ];
    return password_hash($string, PASSWORD_BCRYPT, $options);
}
function get_ip_address() {
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && filter_var($_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP)) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
            $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            foreach ($iplist as $ip) {
                if (filter_var($ip, FILTER_VALIDATE_IP))
                    return $ip;
            }
        } else {
            if (filter_var($_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP))
                return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED']) && filter_var($_SERVER['HTTP_X_FORWARDED'], FILTER_VALIDATE_IP))
        return $_SERVER['HTTP_X_FORWARDED'];
    if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && filter_var($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'], FILTER_VALIDATE_IP))
        return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && filter_var($_SERVER['HTTP_FORWARDED_FOR'], FILTER_VALIDATE_IP))
        return $_SERVER['HTTP_FORWARDED_FOR'];
    if (!empty($_SERVER['HTTP_FORWARDED']) && filter_var($_SERVER['HTTP_FORWARDED'], FILTER_VALIDATE_IP))
        return $_SERVER['HTTP_FORWARDED'];
    return $_SERVER['REMOTE_ADDR'];
}
function get_ip() {
    $ip = get_ip_address();
    $ipInfo = file_get_contents('http://ip-api.com/json/' . $ip);
    $ipInfo = json_decode($ipInfo);
    $data = $ipInfo;
}
function GetConfig() {
    global $db;
    $data = array();
    $configs = $db->get('ws_config');
    foreach ($configs as $key => $config) {
        $data[$config->name] = $config->value;
    }
    return $data;
}
function GetInstagram($username) {
    global $db;
    $instagram = $db->where('username', $username)->getOne('ws_users_instagram');
    if ($instagram) {
        return $instagram;
    }
}
function validaCPF($cpf) {
    // Extrai somente os números
    $cpf = preg_replace('/[^0-9]/is', '', $cpf);
    // Verifica se foi informado todos os digitos corretamente
    if (strlen($cpf) != 11) {
        return false;
    }
    // Verifica se foi informada uma sequência de digitos repetidos. Ex: 111.111.111-11
    if (preg_match('/(\d)\1{10}/', $cpf)) {
        return false;
    }
    // Faz o calculo para validar o CPF
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) {
            return false;
        }
    }
    return true;
}
function validaemail($email) {
    //verifica se e-mail esta no formato correto de escrita
    /* if (!ereg('^([a-zA-Z0-9.-_])*([@])([a-z0-9]).([a-z]{2,3})', $email)) {
      $mensagem = 'E-mail Inv&aacute;lido!';
      return false;
      } else {
      //Valida o dominio
      $dominio = explode('@', $email);
      if (!checkdnsrr($dominio[1], 'A')) {
      return false;
      } else {
      return true;
      } // Retorno true para indicar que o e-mail é valido
      } */
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        return true;
    } else {
        return false;
    }
}
function PT_limpaCPF_CNPJ($valor) {
    $valor = trim($valor);
    $valor = str_replace(".", "", $valor);
    $valor = str_replace(",", "", $valor);
    $valor = str_replace("-", "", $valor);
    $valor = str_replace("_", "", $valor);
    $valor = str_replace("/", "", $valor);
    $valor = str_replace("(", "", $valor);
    $valor = str_replace(")", "", $valor);
    $valor = str_replace(" ", "", $valor);
    return $valor;
}
function limpaIMG($valor) {
    $valor = trim($valor);
    $valor = str_replace(",", "_.", $valor);
    $valor = str_replace("/", "_.", $valor);
    $valor = str_replace("(", "_.", $valor);
    $valor = str_replace(")", "_.", $valor);
    $valor = str_replace("%", "_.", $valor);
    $valor = str_replace("*", "_.", $valor);
    $valor = str_replace("&", "_.", $valor);
    $valor = str_replace("¨", "_.", $valor);
    $valor = str_replace("$", "_.", $valor);
    $valor = str_replace("#", "_.", $valor);
    $valor = str_replace("@", "_.", $valor);
    $valor = str_replace("!", "_.", $valor);
    $valor = str_replace(" ", "_.", $valor);
    return $valor;
}
function PT_Link($string = '') {
    global $site_url;
    return $site_url . '/' . $string;
}
function PT_Slug($string, $video_id) {
    global $pt;
    $slug = url_slug($string, array(
        'delimiter' => '-',
        'limit' => 100,
        'lowercase' => true,
        'replacements' => array(
            '/\b(an)\b/i' => 'a',
            '/\b(example)\b/i' => 'Test'
        )
    ));
    return $slug . '_' . $video_id . '.html';
}
function current_url() {
    return BASE . $_SERVER['REQUEST_URI'];
}
function LoadMidias($order = 'asc') {
    global $pt, $db;
    $list = $db->orderBy('midia_ordem', $order)->get('ws_midias');
    if ($list) {
        return $list;
    } else {
        return false;
    }
}
function byteFormat($bytes, $unit = "", $decimals = 2) {
    $units = array('B' => 0, 'KB' => 1, 'MB' => 2, 'GB' => 3, 'TB' => 4,
        'PB' => 5, 'EB' => 6, 'ZB' => 7, 'YB' => 8);
    $value = 0;
    if ($bytes > 0) {
// Generate automatic prefix by bytes 
// If wrong prefix given
        if (!array_key_exists($unit, $units)) {
            $pow = floor(log($bytes) / log(1024));
            $unit = array_search($pow, $units);
        }
// Calculate byte value by prefix
        $value = ($bytes / pow(1024, floor($units[$unit])));
    }
// If decimals is not numeric or decimals is less than 0 
// then set default value
    if (!is_numeric($decimals) || $decimals < 0) {
        $decimals = 2;
    }
// Format output
    return sprintf('%.' . $decimals . 'f ' . $unit, $value);
}
function transformaMoeda($valor) {
    $novoValor = number_format($valor / 100, 2, ".", "");
    return $novoValor;
}
function PT_GenerateKey($minlength = 20, $maxlength = 20, $uselower = true, $useupper = true, $usenumbers = true, $usespecial = false) {
    $charset = '';
    if ($uselower) {
        $charset .= "abcdefghijklmnopqrstuvwxyz";
    }
    if ($useupper) {
        $charset .= "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    }
    if ($usenumbers) {
        $charset .= "123456789";
    }
    if ($usespecial) {
        $charset .= "~@#$%^*()_+-={}|][";
    }
    if ($minlength > $maxlength) {
        $length = mt_rand($maxlength, $minlength);
    } else {
        $length = mt_rand($minlength, $maxlength);
    }
    $key = '';
    for ($i = 0; $i < $length; $i++) {
        $key .= $charset[(mt_rand(0, strlen($charset) - 1))];
    }
    return $key;
}
function PT_URLSlug($string, $id) {
    global $pt;
    $slug = url_slug($string, array(
        'delimiter' => '-',
        'limit' => 100,
        'lowercase' => true,
        'replacements' => array(
            '/\b(an)\b/i' => 'a',
            '/\b(example)\b/i' => 'Test'
        )
    ));
    return $slug;
}
function url_slug($str, $options = array()) {
// Make sure string is in UTF-8 and strip invalid UTF-8 characters
    $str = mb_convert_encoding((string) $str, 'UTF-8', mb_list_encodings());
    $defaults = array(
        'delimiter' => '-',
        'limit' => null,
        'lowercase' => true,
        'replacements' => array(),
        'transliterate' => false
    );
// Merge options
    $options = array_merge($defaults, $options);
    $char_map = array(
// Latin
        'Ã€' => 'A',
        'Ã�' => 'A',
        'Ã‚' => 'A',
        'Ãƒ' => 'A',
        'Ã„' => 'A',
        'Ã…' => 'A',
        'Ã†' => 'AE',
        'Ã‡' => 'C',
        'Ãˆ' => 'E',
        'Ã‰' => 'E',
        'ÃŠ' => 'E',
        'Ã‹' => 'E',
        'ÃŒ' => 'I',
        'Ã�' => 'I',
        'ÃŽ' => 'I',
        'Ã�' => 'I',
        'Ã�' => 'D',
        'Ã‘' => 'N',
        'Ã’' => 'O',
        'Ã“' => 'O',
        'Ã”' => 'O',
        'Ã•' => 'O',
        'Ã–' => 'O',
        'Å�' => 'O',
        'Ã˜' => 'O',
        'Ã™' => 'U',
        'Ãš' => 'U',
        'Ã›' => 'U',
        'Ãœ' => 'U',
        'Å°' => 'U',
        'Ã�' => 'Y',
        'Ãž' => 'TH',
        'ÃŸ' => 'ss',
        'Ã ' => 'a',
        'Ã¡' => 'a',
        'Ã¢' => 'a',
        'Ã£' => 'a',
        'Ã¤' => 'a',
        'Ã¥' => 'a',
        'Ã¦' => 'ae',
        'Ã§' => 'c',
        'Ã¨' => 'e',
        'Ã©' => 'e',
        'Ãª' => 'e',
        'Ã«' => 'e',
        'Ã¬' => 'i',
        'Ã­' => 'i',
        'Ã®' => 'i',
        'Ã¯' => 'i',
        'Ã°' => 'd',
        'Ã±' => 'n',
        'Ã²' => 'o',
        'Ã³' => 'o',
        'Ã´' => 'o',
        'Ãµ' => 'o',
        'Ã¶' => 'o',
        'Å‘' => 'o',
        'Ã¸' => 'o',
        'Ã¹' => 'u',
        'Ãº' => 'u',
        'Ã»' => 'u',
        'Ã¼' => 'u',
        'Å±' => 'u',
        'Ã½' => 'y',
        'Ã¾' => 'th',
        'Ã¿' => 'y',
        // Latin symbols
        'Â©' => '(c)',
        // Greek
        'Î‘' => 'A',
        'Î’' => 'B',
        'Î“' => 'G',
        'Î”' => 'D',
        'Î•' => 'E',
        'Î–' => 'Z',
        'Î—' => 'H',
        'Î˜' => '8',
        'Î™' => 'I',
        'Îš' => 'K',
        'Î›' => 'L',
        'Îœ' => 'M',
        'Î�' => 'N',
        'Îž' => '3',
        'ÎŸ' => 'O',
        'Î ' => 'P',
        'Î¡' => 'R',
        'Î£' => 'S',
        'Î¤' => 'T',
        'Î¥' => 'Y',
        'Î¦' => 'F',
        'Î§' => 'X',
        'Î¨' => 'PS',
        'Î©' => 'W',
        'Î†' => 'A',
        'Îˆ' => 'E',
        'ÎŠ' => 'I',
        'ÎŒ' => 'O',
        'ÎŽ' => 'Y',
        'Î‰' => 'H',
        'Î�' => 'W',
        'Îª' => 'I',
        'Î«' => 'Y',
        'Î±' => 'a',
        'Î²' => 'b',
        'Î³' => 'g',
        'Î´' => 'd',
        'Îµ' => 'e',
        'Î¶' => 'z',
        'Î·' => 'h',
        'Î¸' => '8',
        'Î¹' => 'i',
        'Îº' => 'k',
        'Î»' => 'l',
        'Î¼' => 'm',
        'Î½' => 'n',
        'Î¾' => '3',
        'Î¿' => 'o',
        'Ï€' => 'p',
        'Ï�' => 'r',
        'Ïƒ' => 's',
        'Ï„' => 't',
        'Ï…' => 'y',
        'Ï†' => 'f',
        'Ï‡' => 'x',
        'Ïˆ' => 'ps',
        'Ï‰' => 'w',
        'Î¬' => 'a',
        'Î­' => 'e',
        'Î¯' => 'i',
        'ÏŒ' => 'o',
        'Ï�' => 'y',
        'Î®' => 'h',
        'ÏŽ' => 'w',
        'Ï‚' => 's',
        'ÏŠ' => 'i',
        'Î°' => 'y',
        'Ï‹' => 'y',
        'Î�' => 'i',
        // Turkish
        'Åž' => 'S',
        'Ä°' => 'I',
        'Ã‡' => 'C',
        'Ãœ' => 'U',
        'Ã–' => 'O',
        'Äž' => 'G',
        'ÅŸ' => 's',
        'Ä±' => 'i',
        'Ã§' => 'c',
        'Ã¼' => 'u',
        'Ã¶' => 'o',
        'ÄŸ' => 'g',
        // Russian
        'Ð�' => 'A',
        'Ð‘' => 'B',
        'Ð’' => 'V',
        'Ð“' => 'G',
        'Ð”' => 'D',
        'Ð•' => 'E',
        'Ð�' => 'Yo',
        'Ð–' => 'Zh',
        'Ð—' => 'Z',
        'Ð˜' => 'I',
        'Ð™' => 'J',
        'Ðš' => 'K',
        'Ð›' => 'L',
        'Ðœ' => 'M',
        'Ð�' => 'N',
        'Ðž' => 'O',
        'ÐŸ' => 'P',
        'Ð ' => 'R',
        'Ð¡' => 'S',
        'Ð¢' => 'T',
        'Ð£' => 'U',
        'Ð¤' => 'F',
        'Ð¥' => 'H',
        'Ð¦' => 'C',
        'Ð§' => 'Ch',
        'Ð¨' => 'Sh',
        'Ð©' => 'Sh',
        'Ðª' => '',
        'Ð«' => 'Y',
        'Ð¬' => '',
        'Ð­' => 'E',
        'Ð®' => 'Yu',
        'Ð¯' => 'Ya',
        'Ð°' => 'a',
        'Ð±' => 'b',
        'Ð²' => 'v',
        'Ð³' => 'g',
        'Ð´' => 'd',
        'Ðµ' => 'e',
        'Ñ‘' => 'yo',
        'Ð¶' => 'zh',
        'Ð·' => 'z',
        'Ð¸' => 'i',
        'Ð¹' => 'j',
        'Ðº' => 'k',
        'Ð»' => 'l',
        'Ð¼' => 'm',
        'Ð½' => 'n',
        'Ð¾' => 'o',
        'Ð¿' => 'p',
        'Ñ€' => 'r',
        'Ñ�' => 's',
        'Ñ‚' => 't',
        'Ñƒ' => 'u',
        'Ñ„' => 'f',
        'Ñ…' => 'h',
        'Ñ†' => 'c',
        'Ñ‡' => 'ch',
        'Ñˆ' => 'sh',
        'Ñ‰' => 'sh',
        'ÑŠ' => '',
        'Ñ‹' => 'y',
        'ÑŒ' => '',
        'Ñ�' => 'e',
        'ÑŽ' => 'yu',
        'Ñ�' => 'ya',
        // Ukrainian
        'Ð„' => 'Ye',
        'Ð†' => 'I',
        'Ð‡' => 'Yi',
        'Ò�' => 'G',
        'Ñ”' => 'ye',
        'Ñ–' => 'i',
        'Ñ—' => 'yi',
        'Ò‘' => 'g',
        // Czech
        'ÄŒ' => 'C',
        'ÄŽ' => 'D',
        'Äš' => 'E',
        'Å‡' => 'N',
        'Å˜' => 'R',
        'Å ' => 'S',
        'Å¤' => 'T',
        'Å®' => 'U',
        'Å½' => 'Z',
        'Ä�' => 'c',
        'Ä�' => 'd',
        'Ä›' => 'e',
        'Åˆ' => 'n',
        'Å™' => 'r',
        'Å¡' => 's',
        'Å¥' => 't',
        'Å¯' => 'u',
        'Å¾' => 'z',
        // Polish
        'Ä„' => 'A',
        'Ä†' => 'C',
        'Ä˜' => 'e',
        'Å�' => 'L',
        'Åƒ' => 'N',
        'Ã“' => 'o',
        'Åš' => 'S',
        'Å¹' => 'Z',
        'Å»' => 'Z',
        'Ä…' => 'a',
        'Ä‡' => 'c',
        'Ä™' => 'e',
        'Å‚' => 'l',
        'Å„' => 'n',
        'Ã³' => 'o',
        'Å›' => 's',
        'Åº' => 'z',
        'Å¼' => 'z',
        // Latvian
        'Ä€' => 'A',
        'ÄŒ' => 'C',
        'Ä’' => 'E',
        'Ä¢' => 'G',
        'Äª' => 'i',
        'Ä¶' => 'k',
        'Ä»' => 'L',
        'Å…' => 'N',
        'Å ' => 'S',
        'Åª' => 'u',
        'Å½' => 'Z',
        'Ä�' => 'a',
        'Ä�' => 'c',
        'Ä“' => 'e',
        'Ä£' => 'g',
        'Ä«' => 'i',
        'Ä·' => 'k',
        'Ä¼' => 'l',
        'Å†' => 'n',
        'Å¡' => 's',
        'Å«' => 'u',
        'Å¾' => 'z'
    );
// Make custom replacements
    $str = preg_replace(array_keys($options['replacements']), $options['replacements'], $str);
// Transliterate characters to ASCII
    if ($options['transliterate']) {
        $str = str_replace(array_keys($char_map), $char_map, $str);
    }
// Replace non-alphanumeric characters with our delimiter
    $str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
// Remove duplicate delimiters
    $str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
// Truncate slug to max. characters
    $str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
// Remove delimiter from ends
    $str = trim($str, $options['delimiter']);
    return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
}
function br2nl($st) {
    $breaks = array(
        "<br />",
        "<br>",
        "<br/>"
    );
    return str_ireplace($breaks, "\r\n", $st);
}
function loginAdmin(array $array) {
    global $db;
    $loginAdmin = $db->where('user_email', $array['user'])->where('user_password', $array['pass'])->where('user_level', $array['level'], '<=')->getOne('ws_users');
    if (isset($loginAdmin)) {
        return $loginAdmin;
    } else {
        return false;
    }
}
function CookieAffiliate($id) {
    $expira = time() + 3600 * 24 * 30 * 12 * 1;
    setCookie('afiliados', base64_encode($id), $expira, '/');
}
function CookieAdmin(array $array) {
    $expira = time() + 60 * 60 * 24 * 30;
    setCookie('CookieLembrete', base64_encode($array['lembrete']), $expira, '/');
    setCookie('CookieEmail', base64_encode($array['email']), $expira, '/');
    setCookie('CookieSenha', base64_encode($array['senha']), $expira, '/');
}
function base_url($string = '') {
    return BASE . '/' . $string;
}
function CookieAdminError() {
    $_SESSION['CookieLembrete'] = setCookie('CookieLembrete');
    $_SESSION['CookieEmail'] = setCookie('CookieEmail');
    $_SESSION['CookieSenha'] = setCookie('CookieSenha');
}
function PT_ShareFile($data = array(), $type = 0, $fileType = 'image', $folder = 'photos') {
    global $pt, $mysqli, $db;
    $allowed = '';
    if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder . '/' . date('Y'))) {
        @mkdir($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder . '/' . date('Y'), 0777, true);
    }
    if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/uploads')) {
        @mkdir($_SERVER['DOCUMENT_ROOT'] . '/uploads', 0777, true);
    }
    if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder)) {
        @mkdir($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder, 0777, true);
    }
    if (!file_exists($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder . '/' . date('Y') . '/' . date('m'))) {
        @mkdir($_SERVER['DOCUMENT_ROOT'] . '/uploads/' . $folder . '/' . date('Y') . '/' . date('m'), 0777, true);
    }
    if (isset($data['file']) && !empty($data['file'])) {
        $data['file'] = $data['file'];
    }
    if (isset($data['name']) && !empty($data['name'])) {
        $data['name'] = PT_Secure($data['name']);
    }
    if (isset($data['name']) && !empty($data['name'])) {
        $data['name'] = PT_Secure($data['name']);
    }
    if (empty($data)) {
        return false;
    }
    $allowed = 'jpg,png,jpeg,gif,mp4,mov,webm,mpeg,3gp,mkv,mk3d,mks';
    if (!empty($data['allowed'])) {
        $allowed = $data['allowed'];
    }
    $new_string = pathinfo($data['name'], PATHINFO_FILENAME) . '.' . strtolower(pathinfo($data['name'], PATHINFO_EXTENSION));
    $extension_allowed = explode(',', $allowed);
    $file_extension = pathinfo($new_string, PATHINFO_EXTENSION);
    if (!in_array($file_extension, $extension_allowed)) {
        return array(
            'error' => 'File format not supported'
        );
    }
    if (empty($folder) || empty($fileType)) {
        return false;
    }
    $ar = array(
        'video/mp4',
        'video/mov',
        'video/3gp',
        'video/3gpp',
        'video/mpeg',
        'video/flv',
        'video/avi',
        'video/webm',
        'audio/wav',
        'audio/mpeg',
        'video/quicktime',
        'audio/mp3',
        'image/png',
        'image/jpeg',
        'image/gif',
        'video/x-msvideo',
        'video/msvideo',
        'video/x-ms-wmv',
        'video/x-flv',
        'video/x-matroska',
        'video/webm'
    );
    if (!in_array($data['type'], $ar)) {
        return array(
            'error' => 'Formato de arquivo não suportado'
        );
    }
    $dir = "uploads/{$folder}/" . date('Y') . '/' . date('m');
    $filename = $dir . '/' . PT_GenerateKey() . '_' . date('d') . '_' . md5(time()) . "_{$fileType}.{$file_extension}";
    $second_file = pathinfo($filename, PATHINFO_EXTENSION);
    if (move_uploaded_file($data['file'], $_SERVER['DOCUMENT_ROOT'] . '/' . $filename)) {
        if ($second_file == 'jpg' || $second_file == 'jpeg' || $second_file == 'png' || $second_file == 'gif') {
            if ($type == 1) {
                @PT_CompressImage($filename, $filename, 50);
                $explode2 = @end(explode('.', $filename));
                $explode3 = @explode('.', $filename);
                $last_file = $explode3[0] . '_small.' . $explode2;
                @PT_Resize_Crop_Image(400, 400, $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, $last_file, 60);
                if (($pt->config->s3_upload == 'on' || $pt->config->ftp_upload == 'on') && !empty($last_file)) {
                    $upload_s3 = PT_UploadToS3($last_file);
                }
                if (($pt->config->s3_upload == 'on' || $pt->config->ftp_upload == 'on') && !empty($last_file)) {
                    $upload_s3 = PT_UploadToS3($last_file);
                }
            } else {
                if ($second_file != 'gif') {
                    if (!empty($data['crop'])) {
//$crop_image = PT_Resize_Crop_Image($data['crop']['width'], $data['crop']['height'], $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, 60);
                        $crop_image = PT_Resize_Crop_Image($data['crop']['width'], $data['crop']['height'], $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, 60);
                    }
                    @PT_CompressImage($_SERVER['DOCUMENT_ROOT'] . '/' . $filename, $_SERVER['DOCUMENT_ROOT'] . '/' . $filename, 90);
                }
                if (($pt->config->s3_upload == 'on' || $pt->config->ftp_upload == 'on') && !empty($_SERVER['DOCUMENT_ROOT'] . '/' . $filename)) {
                    $upload_s3 = PT_UploadToS3($_SERVER['DOCUMENT_ROOT'] . '/' . $filename);
                }
            }
        } else {
            if (($pt->config->s3_upload == 'on' || $pt->config->ftp_upload == 'on') && !empty($_SERVER['DOCUMENT_ROOT'] . '/' . $filename)) {
                $upload_s3 = PT_UploadToS3($_SERVER['DOCUMENT_ROOT'] . '/' . $filename);
            }
        }
        $last_data = array();
        $last_data['filename'] = $filename;
        $last_data['name'] = $data['name'];
        return $last_data;
    }
}
function PT_CheckMainSession($hash = '') {
    if (!isset($_SESSION['main_hash_id']) || empty($_SESSION['main_hash_id'])) {
        return false;
    }
    if (empty($hash)) {
        return false;
    }
    if ($hash == $_SESSION['main_hash_id']) {
        return true;
    }
    return false;
}
function PT_UploadToS3($filename, $config = array()) {
    global $pt;
    if ($pt->config->s3_upload != 'on' && $pt->config->ftp_upload != 'on') {
        return false;
    }
    if ($pt->config->ftp_upload == "on") {
        $ftp = new \FtpClient\FtpClient();
        $ftp->connect($pt->config->ftp_host, false, $pt->config->ftp_port);
        $login = $ftp->login($pt->config->ftp_username, $pt->config->ftp_password);
        if ($login) {
            if (!empty($pt->config->ftp_path)) {
                if ($pt->config->ftp_path != "./") {
                    $ftp->chdir($pt->config->ftp_path);
                }
            }
            $file_path = substr($filename, 0, strrpos($filename, '/'));
            $file_path_info = explode('/', $file_path);
            $path = '';
            if (!$ftp->isDir($file_path)) {
                foreach ($file_path_info as $key => $value) {
                    if (!empty($path)) {
                        $path .= '/' . $value . '/';
                    } else {
                        $path .= $value . '/';
                    }
                    if (!$ftp->isDir($path)) {
                        $mkdir = $ftp->mkdir($path);
                    }
                }
            }
            $ftp->chdir($file_path);
            $ftp->pasv(true);
            if ($ftp->putFromPath($filename)) {
                if (empty($config['delete'])) {
                    if (empty($config['amazon'])) {
                        @unlink($filename);
                    }
                }
                $ftp->close();
                return true;
            }
            $ftp->close();
        }
    } else {
        $s3Config = (
                empty($pt->config->amazone_s3_key) ||
                empty($pt->config->amazone_s3_s_key) ||
                empty($pt->config->region) ||
                empty($pt->config->s3_bucket_name)
                );
        if ($s3Config) {
            return false;
        }
        $s3 = new S3Client([
            'version' => 'latest',
            'region' => $pt->config->region,
            'credentials' => [
                'key' => $pt->config->amazone_s3_key,
                'secret' => $pt->config->amazone_s3_s_key,
            ]
        ]);
        $s3->putObject([
            'Bucket' => $pt->config->s3_bucket_name,
            'Key' => $filename,
            'Body' => fopen($filename, 'r+'),
            'ACL' => 'public-read',
        ]);
        if (empty($config['delete'])) {
            if ($s3->doesObjectExist($pt->config->s3_bucket_name, $filename)) {
                if (empty($config['amazon'])) {
                    @unlink($filename);
                }
                return true;
            }
        } else {
            return true;
        }
    }
}
function PT_DeleteFromToS3($filename, $config = array()) {
    global $pt;
    if ($pt->config->s3_upload != 'on' && $pt->config->ftp_upload != 'on') {
        return false;
    }
    if ($pt->config->ftp_upload == "on") {
        $ftp = new \FtpClient\FtpClient();
        $ftp->connect($pt->config->ftp_host, false, $pt->config->ftp_port);
        $login = $ftp->login($pt->config->ftp_username, $pt->config->ftp_password);
        if ($login) {
            if (!empty($pt->config->ftp_path)) {
                if ($pt->config->ftp_path != "./") {
                    $ftp->chdir($pt->config->ftp_path);
                }
            }
            $file_path = substr($filename, 0, strrpos($filename, '/'));
            $file_name = substr($filename, strrpos($filename, '/') + 1);
            $file_path_info = explode('/', $file_path);
            $path = '';
            if (!$ftp->isDir($file_path)) {
                return false;
            }
            $ftp->chdir($file_path);
            $ftp->pasv(true);
            if ($ftp->remove($file_name)) {
                return true;
            }
        }
    } else {
        $s3Config = (
                empty($pt->config->amazone_s3_key) ||
                empty($pt->config->amazone_s3_s_key) ||
                empty($pt->config->region) ||
                empty($pt->config->s3_bucket_name)
                );
        if ($s3Config) {
            return false;
        }
        $s3 = new S3Client([
            'version' => 'latest',
            'region' => $pt->config->region,
            'credentials' => [
                'key' => $pt->config->amazone_s3_key,
                'secret' => $pt->config->amazone_s3_s_key,
            ]
        ]);
        $s3->deleteObject([
            'Bucket' => $pt->config->s3_bucket_name,
            'Key' => $filename,
        ]);
        if (!$s3->doesObjectExist($pt->config->s3_bucket_name, $filename)) {
            return true;
        }
    }
}
function PT_Resize_Crop_Image($max_width, $max_height, $source_file, $dst_dir, $quality = 80) {
    $imgsize = @getimagesize($source_file);
    $width = $imgsize[0];
    $height = $imgsize[1];
    $mime = $imgsize['mime'];
    switch ($mime) {
        case 'image/gif':
            $image_create = "imagecreatefromgif";
            $image = "imagegif";
            break;
        case 'image/png':
            $image_create = "imagecreatefrompng";
            $image = "imagepng";
            break;
        case 'image/jpeg':
            $image_create = "imagecreatefromjpeg";
            $image = "imagejpeg";
            break;
        default:
            return false;
            break;
    }
    $dst_img = @imagecreatetruecolor($max_width, $max_height);
    $src_img = $image_create($source_file);
    $width_new = $height * $max_width / $max_height;
    $height_new = $width * $max_height / $max_width;
    if ($width_new > $width) {
        $h_point = (($height - $height_new) / 2);
        @imagecopyresampled($dst_img, $src_img, 0, 0, 0, $h_point, $max_width, $max_height, $width, $height_new);
    } else {
        $w_point = (($width - $width_new) / 2);
        @imagecopyresampled($dst_img, $src_img, 0, 0, $w_point, 0, $max_width, $max_height, $width_new, $height);
    }
    @imagejpeg($dst_img, $dst_dir, $quality);
    if ($dst_img)
        @imagedestroy($dst_img);
    if ($src_img)
        @imagedestroy($src_img);
}
function PT_CompressImage($source_url, $destination_url, $quality) {
    $info = getimagesize($source_url);
    if ($info['mime'] == 'image/jpeg') {
        $image = @imagecreatefromjpeg($source_url);
        @imagejpeg($image, $destination_url, $quality);
    } elseif ($info['mime'] == 'image/gif') {
        $image = @imagecreatefromgif($source_url);
        @imagegif($image, $destination_url, $quality);
    } elseif ($info['mime'] == 'image/png') {
        $image = @imagecreatefrompng($source_url);
        @imagepng($image, $destination_url);
    }
}
function PT_UploadLogo($data = array()) {
    global $pt, $db;
    if (isset($data['file']) && !empty($data['file'])) {
        $data['file'] = PT_Secure($data['file']);
    }
    if (isset($data['name']) && !empty($data['name'])) {
        $data['name'] = PT_Secure($data['name']);
    }
    if (isset($data['name']) && !empty($data['name'])) {
        $data['name'] = PT_Secure($data['name']);
    }
    if (empty($data)) {
        return false;
    }
    $allowed = 'png';
    $new_string = pathinfo($data['name'], PATHINFO_FILENAME) . '.' . strtolower(pathinfo($data['name'], PATHINFO_EXTENSION));
    $extension_allowed = explode(',', $allowed);
    $file_extension = pathinfo($new_string, PATHINFO_EXTENSION);
    if (!in_array($file_extension, $extension_allowed)) {
        return false;
    }
    $logo_name = 'logo';
    if (!empty($data['favicon'])) {
        $logo_name = 'icon';
    }
    $dir = "themes/" . $pt->config->theme . "/img/";
    $filename = $dir . "$logo_name.png";
    if (move_uploaded_file($data['file'], $_SERVER['DOCUMENT_ROOT'] . '/' . $filename)) {
        return true;
    }
}
function selectCatSubProjetos($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent AND `type` = 'projetos' ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "type" => $row->type,
            );
            $user_tree_array = selectCatSubProjetos($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function selectCatSub($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "type" => $row->type,
            );
            $user_tree_array = selectCatSub($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function fetchCategoryTree($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_parent" => $row->parent,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "category_order" => $row->ordem,
                "type" => $row->type,
            );
            $user_tree_array = fetchCategoryTree($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function fetchCategoryTreePosts($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_parent" => $row->parent,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "type" => $row->type,
            );
            $user_tree_array = fetchCategoryTreePosts($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function fetchCategoryTreeProdutos($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_parent" => $row->parent,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "type" => $row->type,
            );
            $user_tree_array = fetchCategoryTreeProdutos($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function fetchCategoryTreeEventos($parent = 0, $spacing = ' ', $user_tree_array = '') {
    global $db;
    if (!is_array($user_tree_array))
        $user_tree_array = array();
    $cats = $db->rawQuery("SELECT * FROM ws_term_taxonomy WHERE 1 AND `parent` = $parent ORDER BY term_id ASC");
    if (count($cats) > 0) {
        foreach ($cats as $row) {
            $cat = $db->where('term_id', $row->term_id)->getOne('ws_terms');
            $user_tree_array[] = array(
                "category_id" => $row->term_id,
                "category_title" => $spacing . $cat->name,
                "category_name" => $cat->slug,
                "category_content" => $row->description,
                "category_parent" => $row->parent,
                "category_views" => $row->count,
                "category_type" => $row->taxonomy,
                "type" => $row->type,
            );
            $user_tree_array = fetchCategoryTreeEventos($row->term_id, $spacing . ' — ', $user_tree_array);
        }
    }
    return $user_tree_array;
}
function ws_term_relationships($param, $id, $order = 0) {
    global $db, $mysqli;
    $update = new Update;
    $read = new Read;
    $create = new Create;
    $delete = new Delete;
    $opcao = $param;
    $cad['object_id'] = $id;
    $cad['term_order'] = $order;
    $contar = count($opcao);
    for ($i = 0; $i < $contar; $i++):
        $cad['term_taxonomy_id'] = $opcao[$i];
        $read->ExeRead("ws_term_relationships", "where object_id = :post and term_taxonomy_id = :catid", "post={$id}&catid={$cad['term_taxonomy_id']}");
        if ($read->getResult()):
            $update->ExeUpdate("ws_term_relationships", $cad, "where object_id = :post and term_taxonomy_id = :catid", "post={$id}&catid={$cad['term_taxonomy_id']}");
            if ($update->getResult()):
            endif;
        else:
            $create->ExeCreate("ws_term_relationships", $cad);
            if ($create->getResult()):
            endif;
        endif;
        $read->ExeRead("ws_term_relationships", "where term_taxonomy_id = :catid", "catid={$cad['term_taxonomy_id']}");
        $update->ExeUpdate("ws_term_taxonomy", array('count' => count($read->getResult())), "where term_id = :catid", "catid={$cad['term_taxonomy_id']}");
    endfor;
}
function BannerOneLanding($type = 'landing', $limit = 1) {
    global $pt, $db;
    $banner = $db->rawQuery("select * from ws_posts where type = '" . $type . "' limit {$limit}");
    if ($banner) {
        return $banner;
    }
}
function removeGaleria($id) {
    global $pt, $db;
    $resImg = $db->where('gallery_id', $id)->getOne('ws_posts_gallery');
    if ($resImg) {
        if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $resImg->gallery_image)) {
            unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $resImg->gallery_image);
        }
        if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $resImg->gallery_image_capa)) {
            unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $resImg->gallery_image_capa);
        }
        $delete = $db->where('gallery_id', $id)->delete('ws_posts_gallery');
        if ($delete) {
            return true;
        } else {
            return false;
        }
    }
}
function removeModelo($id) {
    global $pt, $db;
    $delete = $db->where('modelo_id', $id)->delete('ws_modelos');
    if ($delete) {
        return true;
    } else {
        return false;
    }
}
function TotalVisitas() {
    global $pt, $db;
    $visitas = $db->get('ws_siteviews_online');
    if ($visitas) {
        return count($visitas);
    }
}
function TotalPosts($type, $status = 1) {
    global $pt, $db;
    $total = $db->where('post_status', $status)->where('post_type', $type)->get('ws_posts');
    if (count($total) < 1) {
        return 0;
    } else {
        return count($total);
    }
}
function pegaUsuarioInstagram($url) {
    $regex = '/(?:(?:http|https):\/\/)?(?:www.)?(?:instagram.com|instagr.am)\/([A-Za-z0-9-_\.]+)/im';
    if (preg_match($regex, $url, $saida)) {
        $usuario = $saida[1];
        return $usuario;
    }
}
function UsuarioInstagram($string, $expressao = 'https://', $expressao2 = 'http://') {
    if (strpos("[" . $string . "]", "$expressao")) {
        $explode = explode("/", $string);
        $str = pegaUsuarioInstagram($string);
    } elseif (strpos("[" . $string . "]", "$expressao2")) {
        $explode = explode("/", $string);
        $str = pegaUsuarioInstagram($string);
    } else {
        $str = RemoveArroba($string);
    }
    return $str;
}
function validateRequired($value) {
    return empty($value) ? "Campo obrigatório" : false;
}
function validateEmail($value) {
    $email = filter_var($value, FILTER_SANITIZE_EMAIL);
    return !filter_var($email, FILTER_VALIDATE_EMAIL) ? "E-mail inválido" : false;
}
function verificaEmailExiste($email) {
    global $db, $pt;
    $verificaEmail = $db->where('user_email', $email)->getOne('ws_users');
    if ($verificaEmail) {
        return true;
    } else {
        return false;
    }
}
function validateMinLength($value, $length) {
    return (strlen($value) < $length) ? "Mínimo {$length} caracteres" : false;
}
function curl_retorno($url) {
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-type:application/x-www-form-urlencoded'
    ));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    $xml = curl_exec($curl);
    curl_close($curl);
    return $xml;
}
function curl_retorno_assinatura($code) {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = "https://ws.sandbox.pagseguro.uol.com.br/pre-approvals/{$code}?email={$pt->config->pagseguro_email}&token={$pt->config->pagseguro_token}";
    else:
        $url = "https://ws.pagseguro.uol.com.br/pre-approvals/{$code}?email={$pt->config->pagseguro_email}&token={$pt->config->pagseguro_token}";
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-type:application/x-www-form-urlencoded'
    ));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    $xml = curl_exec($curl);
    curl_close($curl);
    return $xml;
}
function select_value_uniq($table, $where_key, $id, $campo) {
    global $pt, $db;
    $db->where($where_key, $id);
    $res = $db->getValue($table, $campo, null);
    if ($res[0]) {
        return $res[0];
    } else {
        return false;
    }
}
function script_pagseguro() {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $script = '<script type="text/javascript" src="https://stc.sandbox.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js"></script>';
        $script .= "\n";
    else:
        $script = '<script type="text/javascript" src="https://stc.pagseguro.uol.com.br/pagseguro/api/v2/checkout/pagseguro.directpayment.js"></script>';
        $script .= "\n";
    endif;
    return $script;
}
function curl_retorno_faturas($code) {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = "https://ws.sandbox.pagseguro.uol.com.br/pre-approvals/{$code}/payment-orders?email={$pt->config->pagseguro_email}&token={$pt->config->pagseguro_token}";
    else:
        $url = "https://ws.pagseguro.uol.com.br/pre-approvals/{$code}/payment-orders?email={$pt->config->pagseguro_email}&token={$pt->config->pagseguro_token}";
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-type:application/x-www-form-urlencoded'
    ));
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    $xml = curl_exec($curl);
    curl_close($curl);
    return $xml;
}
function assinarPagseguro($dadosAderirPlano) {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = "https://ws.sandbox.pagseguro.uol.com.br/pre-approvals?email=" . $pt->config->pagseguro_email . "&token=" . $pt->config->pagseguro_token;
    else:
        $url = "https://ws.pagseguro.uol.com.br/pre-approvals?email=" . $pt->config->pagseguro_email . "&token=" . $pt->config->pagseguro_token;
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-Type:application/json'
    ));
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($dadosAderirPlano));
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    return $retorno_transaction;
}
function retornoPagseguroAssinaturas($url) {
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $transaction_curl = trim(curl_exec($curl));
    curl_close($curl);
    $transaction = simplexml_load_string($transaction_curl);
    return $transaction;
}
function idSessaoPagseguro() {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = 'https://ws.sandbox.pagseguro.uol.com.br/v2/sessions?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    else:
        $url = 'https://ws.pagseguro.uol.com.br/v2/sessions?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    $session = simplexml_load_string($retorno_transaction);
    $session = json_encode($session);
    $session = json_decode($session);
    return $session;
}
function criarPlano($url, $dadosCriarPlano) {
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-type:application/x-www-form-urlencoded'
    ));
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($dadosCriarPlano));
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    return $retorno_transaction;
}
function getPlano($url) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "{$url}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => Array(
            'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
            'Content-type:application/x-www-form-urlencoded'
        ),
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        return $response;
    }
}
function updatePlano($url, $dadosUpdatePlano) {
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-Type:application/json'
    ));
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($dadosUpdatePlano));
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    return $retorno_transaction;
}
function updatePlanoAntigo($url, $dadosUpdatePlano) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "{$url}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_POSTFIELDS => http_build_query($dadosUpdatePlano),
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "PUT",
    ));
    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) {
        echo "cURL Error #:" . $err;
    } else {
        echo $response;
    }
}
function cancelar($codigo) {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = 'https://ws.sandbox.pagseguro.uol.com.br/v2/pre-approvals/cancel/' . $codigo . '?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    else:
        $url = 'https://ws.pagseguro.uol.com.br/v2/pre-approvals/cancel/' . $codigo . '?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    return $retorno_transaction;
}
function suspenderAtivarAssinatura($codigo, $status) {
    global $pt;
    if ($pt->config->pagseguro_modo == 'sandbox'):
        $url = 'https://ws.sandbox.pagseguro.uol.com.br/pre-approvals/' . $codigo . '/status?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    else:
        $url = 'https://ws.pagseguro.uol.com.br/pre-approvals/' . $codigo . '/status?email=' . $pt->config->pagseguro_email . '&token=' . $pt->config->pagseguro_token;
    endif;
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, Array(
        'Accept:application/vnd.pagseguro.com.br.v3+json;charset=ISO-8859-1',
        'Content-Type:application/json'
    ));
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode(['status' => $status]));
    $retorno_transaction = curl_exec($curl);
    curl_close($curl);
    return $retorno_transaction;
}
function pagseguro_checkout_basico($data) {
    global $pt;
    if ($pt->config->config_pagseguro_modo == 'sandbox'):
        $url = 'https://ws.sandbox.pagseguro.uol.com.br/v2/checkout';
    else:
        $url = 'https://ws.pagseguro.uol.com.br/v2/checkout';
    endif;
    $data = http_build_query($data);
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    $xml = curl_exec($curl);
//    if ($xml == 'Unauthorized') {
//        return 'Unauthorized';
//        exit;
//    }
    curl_close($curl);
    $xml = simplexml_load_string($xml);
    $xml = json_encode($xml);
    $xml = json_decode($xml);
    return $xml;
}
function UserLogin($session) {
    global $pt, $db;
    $UserLogin = $db->where('user_id', $session->user_id)->where('user_status', 1)->getOne('ws_users');
    if ($UserLogin):
        $userlogin = $UserLogin;
    else:
        unset($session);
        $userlogin = null;
    endif;
    return $userlogin;
}
function DataSemHora($Date) {
    $Format = explode(' ', $Date);
    $Data = explode('/', $Format[0]);
    $Data = $Data[2] . '-' . $Data[1] . '-' . $Data[0];
    return $Data;
}
function PT_Nascimento($Data) {
    $Format = explode(' ', $Data);
    $Data = explode('/', $Format[0]);
    if (checkdate($Data[1], $Data[0], $Data[2])):
        $Data = $Data[2] . '-' . $Data[1] . '-' . $Data[0];
        return $Data;
    else:
        return false;
    endif;
}
function PT_geraCodigo($longitud) {
    $key = '';
    $pattern = '1234567890';
    $max = strlen($pattern) - 1;
    for ($i = 0; $i < $longitud; $i++)
        $key .= $pattern{mt_rand(0, $max)};
    return $key;
}
function PT_DataComHora($Data) {
    $Format = explode(' ', $Data);
    $Data = explode('/', $Format[0]);
    if (!checkdate($Data[1], $Data[0], $Data[2])):
        return false;
    else:
        if (empty($Format[1])):
            $Format[1] = date('H:i:s');
        endif;
        $Data = $Data[2] . '-' . $Data[1] . '-' . $Data[0] . ' ' . $Format[1];
        return $Data;
    endif;
}
function removeAcentos($text) {
    $acentos = array('Á', 'À', 'Â', 'Ã', 'É', 'Ê', 'È', 'Ó', 'Ô', 'Õ', 'Ú', 'Ç', 'á', 'à', 'â', 'ã', 'é', 'ê', 'í', 'ó', 'ô', 'õ', 'ú', 'ç', 'æ');
    $sAcentos = array('A', 'A', 'A', 'A', 'E', 'E', 'I', 'O', 'O', 'O', 'U', 'C', 'a', 'a', 'a', 'a', 'e', 'e', 'i', 'o', 'o', 'o', 'u', 'c', 'AE');
    return str_replace($acentos, $sAcentos, $text);
}
function round_up($value, $places = 0) {
    if ($places < 0) {
        $places = 0;
    }
    $mult = pow(10, $places);
    return ceil($value * $mult) / $mult;
}
function DDD($fone) {
    $explode = explode(")", $fone);
    $dedede = $explode[0];
    return PT_limpaCPF_CNPJ($dedede);
}
function FONE($fone) {
    $explode = explode(")", $fone);
    $fone = $explode[1];
    return PT_limpaCPF_CNPJ($fone);
}
function PT_CPFExists($cpf = '') {
    global $db;
    return ($db->where('cpf', PT_Secure($cpf))->getValue(T_USERS, 'count(*)') > 0) ? true : false;
}
//novas funçoes
function PT_inteiro_decimal_br($valor) {
    return number_format($valor, 2, ',', '.');
}
function Periodicidade($string) {
    if ($string == 'WEEKLY') {
        $periodo = 'Semanal';
    } elseif ($string == 'MONTHLY') {
        $periodo = 'Mensal';
    } elseif ($string == 'BIMONTHLY') {
        $periodo = 'Bimestral';
    } elseif ($string == 'TRIMONTHLY') {
        $periodo = 'Trimestral';
    } elseif ($string == 'SEMIANNUALLY') {
        $periodo = 'Semestral';
    } elseif ($string == 'YEARLY') {
        $periodo = 'Anual';
    }
    return $periodo;
}
function MeioPagamentoPagseguro($metodo) {
    if ($metodo == 'CREDIT_CARD') {
        $metodo = 'Cartão de crédito';
    } else {
        $metodo = 'Boleto';
    }
    return $metodo;
}
function MeioPagamentoPagseguroBasico($metodo) {
    if ($metodo == 1) {
        $metodo = 'credit_card';
    } else if ($metodo == 2) {
        $metodo = 'boleto';
    } else if ($metodo == 3) {
        $metodo = 'debito_online';
    } else if ($metodo == 4) {
        $metodo = 'saldo_pagseguro';
    } else if ($metodo == 5) {
        $metodo = 'oi_pago';
    } else if ($metodo == 7) {
        $metodo = 'deposito_conta';
    }
    return $metodo;
}
function BandeiraPagseguroBasico($bandeira) {
    if ($bandeira == 101) {
        $metodo = 'visa';
    } else if ($bandeira == 102) {
        $metodo = 'mastercard';
    } else if ($bandeira == 103) {
        $metodo = 'americanexpress';
    } else if ($bandeira == 104) {
        $metodo = 'diners';
    } else if ($bandeira == 105) {
        $metodo = 'hipercard';
    } else if ($bandeira == 106) {
        $metodo = 'aura';
    } else if ($bandeira == 107) {
        $metodo = 'elo';
    } else if ($bandeira == 108) {
        $metodo = 'plenocard';
    } else if ($bandeira == 109) {
        $metodo = 'personalcard';
    } else if ($bandeira == 110) {
        $metodo = 'jcb';
    } else if ($bandeira == 111) {
        $metodo = 'discover';
    } else if ($bandeira == 112) {
        $metodo = 'brasilcard';
    } else if ($bandeira == 113) {
        $metodo = 'fortbrasil';
    } else if ($bandeira == 114) {
        $metodo = 'cardban';
    } else if ($bandeira == 115) {
        $metodo = 'valecard';
    } else if ($bandeira == 116) {
        $metodo = 'cabal';
    } else if ($bandeira == 117) {
        $metodo = 'mais';
    } else if ($bandeira == 118) {
        $metodo = 'avista';
    } else if ($bandeira == 119) {
        $metodo = 'grandcard';
    } else if ($bandeira == 120) {
        $metodo = 'sorocred';
    } else if ($bandeira == 201) {
        $metodo = 'boletobradesco';
    } else if ($bandeira == 202) {
        $metodo = 'boletosantander';
    } else if ($bandeira == 301) {
        $metodo = 'debitobradesco';
    } else if ($bandeira == 302) {
        $metodo = 'debitoitau';
    } else if ($bandeira == 303) {
        $metodo = 'debitounibanco';
    } else if ($bandeira == 304) {
        $metodo = 'debitobb';
    } else if ($bandeira == 305) {
        $metodo = 'debitobancoreal';
    } else if ($bandeira == 306) {
        $metodo = 'debitobanrisul';
    } else if ($bandeira == 307) {
        $metodo = 'debitohsbc';
    } else if ($bandeira == 401) {
        $metodo = 'saldopagseguro';
    } else if ($bandeira == 501) {
        $metodo = 'oipaggo';
    } else if ($bandeira == 701) {
        $metodo = 'depositocontabb';
    } else if ($bandeira == 702) {
        $metodo = 'depositocontahsbc';
    }
    return $metodo;
}
function StatusAssinaturaPagseguro($sts) {
    if ($sts == 'ACTIVE') {
        $sts = 'Ativa';
    } elseif ($sts == 'PENDING') {
        $sts = 'Pendente';
    } elseif ($sts == 'INITIATED') {
        $sts = 'Iniciada';
    } elseif ($sts == 'PAYMENT_METHOD_CHANGE') {
        $sts = 'Cartão Expirado, Cancelado ou Bloqueado';
    } elseif ($sts == 'SUSPENDED') {
        $sts = 'Suspensa';
    } elseif ($sts == 'CANCELLED') {
        $sts = 'Cancelada';
    } elseif ($sts == 'CANCELLED_BY_RECEIVER') {
        $sts = 'Cancelada a pedido do vendedor';
    } elseif ($sts == 'CANCELLED_BY_SENDER') {
        $sts = 'Cancelada a pedido do comprador';
    } elseif ($sts == 'EXPIRED') {
        $sts = 'Expirada';
    }
    return $sts;
}
function StatusFaturasPagseguro($sts) {
    if ($sts == 'ACTIVE') {
        $sts = 'Ativa';
    } elseif ($sts == 'PENDING') {
        $sts = 'Pendente';
    } elseif ($sts == 'INITIATED') {
        $sts = 'Iniciada';
    } elseif ($sts == 'PAYMENT_METHOD_CHANGE') {
        $sts = 'Cartão Expirado, Cancelado ou Bloqueado';
    } elseif ($sts == 'SUSPENDED') {
        $sts = 'Suspensa';
    } elseif ($sts == 'CANCELLED') {
        $sts = 'Cancelada';
    } elseif ($sts == 'CANCELLED_BY_RECEIVER') {
        $sts = 'Cancelada a pedido do vendedor';
    } elseif ($sts == 'CANCELLED_BY_SENDER') {
        $sts = 'Cancelada a pedido do comprador';
    } elseif ($sts == 'EXPIRED') {
        $sts = 'Expirada';
    }
    return $sts;
}
function StatusUsers($sts = 0) {
    if ($sts == 0) {
        return '<span class="btn mr-1 mb-1 btn-danger btn-sm">Inativo</span>';
    } elseif ($sts == 1) {
        return '<span class="btn mr-1 mb-1 btn-success btn-sm">Ativo</span>';
    } elseif ($sts == 2) {
        return '<span class="btn mr-1 mb-1 btn-warning btn-sm">Bloqueado</span>';
    }
}
function list_perfil_instagram($user_id = 0, $ordenar = "") {
    global $db, $pt;
    if (empty($ordenar) || $ordenar == "") {
        $list_instagram = $db->where('user_id', $user_id)->get('ws_users_instagram');
    } else {
        $list_instagram = $db->orderBy('id', $ordenar)->where('user_id', $user_id)->getOne('ws_users_instagram');
    }
    if ($list_instagram) {
        return $list_instagram;
    } else {
        return false;
    }
}
function ListMedias($username, $id = 0) {
    global $db, $pt;
    $vetor = [];
    $medias = $db->orderBy('id', 'asc')->where('username', $username)->where('user_instagram_id', $id)->get('ws_medias');
    if ($medias) {
        foreach ($medias as $key => $media) {
            $media_['imageHighResolutionUrl'] = $media->media_image;
            $media_['getType'] = $media->media_type;
            $media_['getId'] = $media->media_id;
            $media_['getShortCode'] = $media->media_shortcode;
            $media_['getCaption'] = $media->media_caption;
            $media_['getCommentsCount'] = ($media->media_comments <= 1) ? 'No comments' : $media->media_comments . ' comments';
            $media_['getLikesCount'] = ($media->media_likes <= 1) ? 'No likes' : $media->media_likes . ' likes';
            $media_['getLink'] = $media->media_link;
            $vetor[] = $media_;
        }
    }
    return $vetor;
}
function InsertMedia($tabela, $array) {
    global $db, $pt;
    $insert = $db->insert($tabela, $array);
}
function setMedias($username, $id = 0, $limite = 50) {
    global $db, $pt;
    $instagram = new \InstagramScraper\Instagram();
    $medias = $instagram->getMedias($username, $limite);
    if ($medias) {
        foreach ($medias as $key => $media) {
            $array = array(
                'username' => $username,
                'media_id' => $media->getId(),
                'media_shortcode' => $media->getShortCode(),
                'media_created_at' => $media->getCreatedTime(),
                'media_caption' => $media->getCaption(),
                'media_comments' => $media->getCommentsCount(),
                'media_likes' => $media->getLikesCount(),
                'media_link' => $media->getLink(),
                'media_image' => $media->getImageHighResolutionUrl(),
                'media_type' => $media->getType(),
                'user_instagram_id' => $id,
            );
            $list_medias = $db->where('user_instagram_id', $id)->where('media_id', $media->getId())->getOne("ws_medias");
            if ($list_medias) {
                $update = $db->where('user_instagram_id', $id)->where('media_id', $media->getId())->update("ws_medias", $array);
            } else {
                $insert = $db->insert("ws_medias", $array);
            }
            /* $media_['imageHighResolutionUrl'] = $media->getImageHighResolutionUrl();
              $media_['getType'] = $media->getType();
              $media_['getId'] = $media->getId();
              $media_['getShortCode'] = $media->getShortCode();
              $media_['getCaption'] = $media->getCaption();
              $media_['getCommentsCount'] = ($media->getCommentsCount() <= 1) ? 'No comments' : $media->getCommentsCount() . ' comments';
              $media_['getLikesCount'] = ($media->getLikesCount() <= 1) ? 'No likes' : $media->getLikesCount() . ' likes';
              $media_['getLink'] = $media->getLink();
              $vetor[] = $media_; */
        }
    }
    return true;
}
function list_perfil_instagram_username($username, $user_id = 0) {
    global $db, $pt;
    if ($user_id <= 0) {
        $list_instagram = $db->where('username', $username)->getOne('ws_users_instagram');
    } else {
        $list_instagram = $db->where('username', $username)->where('user_id', $user_id)->getOne('ws_users_instagram');
    }
    if ($list_instagram) {
        return $list_instagram;
    } else {
        return false;
    }
}
function list_perfil_instagram_username_id($username, $user_id = 0) {
    global $db, $pt;
    $list_instagram = $db->where('username', $username)->where('user_id', $user_id)->getOne('ws_users_instagram');
    if ($list_instagram) {
        return $list_instagram;
    } else {
        return false;
    }
}
function list_perfil_instagram_id($id = 0) {
    global $db, $pt;
    $list_instagram = $db->where('id', $id)->getOne('ws_users_instagram');
    if ($list_instagram) {
        return $list_instagram;
    } else {
        return false;
    }
}
function list_perfil_instagram_active($user_id = 0) {
    global $db, $pt;
    $list_instagram = $db->where('user_id', $user_id)->where('selected', 1)->where('timestamp', time(), '<=')->getOne('ws_users_instagram');
    if ($list_instagram) {
//$_SESSION['user_instagram'] = $list_instagram;
        return $list_instagram;
    } else {
        return false;
    }
}
function GetAssinaturaUserInstagram($user_instagram) {
    global $db, $pt;
    $assinatura = $db->where('instagram_profile', $user_instagram)->getOne('ws_assinaturas');
    if ($assinatura) {
        return $assinatura;
    } else {
        return false;
    }
}
function params_instagram($account, $user_id = 0) {
    if ($user_id <= 0) {
        $params = [
            "Id" => $account->getId(),
            "Username" => $account->getUsername(),
            "Full_name" => $account->getFullName(),
            "Biography" => $account->getBiography(),
            "Profile_picture_url" => $account->getProfilePicUrlHd(),
            "External_link" => $account->getExternalUrl(),
            "Number_of_published_posts" => $account->getMediaCount(),
            "Number_of_followers" => $account->getFollowsCount(),
            "Number_of_follows" => $account->getFollowedByCount(),
            "Is_private" => $account->isPrivate(),
            "Is_verified" => $account->isVerified(),
            'result' => true,
        ];
    } else {
        $params = [
            "Id" => $account->instagram_id,
            "Username" => $account->username,
            "Full_name" => $account->full_name,
            "Biography" => $account->biography,
            "Profile_picture_url" => $account->profile_picture_url,
            "External_link" => $account->external_link,
            "Number_of_published_posts" => $account->number_of_published_posts,
            "Number_of_followers" => $account->number_of_followers,
            "Number_of_follows" => $account->number_of_follows,
            "Is_private" => $account->is_private,
            "Is_verified" => $account->is_verified,
            'result' => true,
        ];
    }
    return $params;
}
function GetPlanoUserInstagram($plano_id) {
    global $db, $pt;
    $plano = $db->where('post_id', $plano_id)->getOne('ws_posts');
    if ($plano) {
        return $plano;
    } else {
        return false;
    }
}
function EnviaOrder($order_id = 0, $status = 'PENDING') {
    global $db, $pt;
    $status = strtoupper($status);
    if ($order_id > 0) {
        $listOrder = $db->rawQuery("select * from ws_ordens where order_id = {$order_id} and order_id_ordem_api IS NULL and order_status = '{$status}' and order_quantidade > 0");
        if (isset($listOrder[0])) {
            $res_ordem = $listOrder[0];
            $res_api = getApi($res_ordem->order_id_api);
            if ($res_api) {
                $params = [
                    'apiKey' => $res_api->token,
                    'api_token' => $res_api->token,
                    'token' => $res_api->token,
                    'keyInterno' => $res_api->token,
                    'actionType' => $res_api->paramAction,
                    'action' => $res_api->paramAction,
                    'actionInterno' => $res_api->paramAction,
                    'id_usuario' => $res_api->id_Usuario,
                    'key' => $res_api->token,
                    'orderType' => $res_ordem->order_service_id,
                    'package' => $res_ordem->order_service_id,
                    'tipo' => $res_api->paramAction,
                    'id_produto' => $res_ordem->order_service_id,
                    'service' => $res_ordem->order_service_id,
                    'serviceInterno' => $res_ordem->order_service_id,
                    'orderUrl' => $res_ordem->order_link,
                    'username' => $res_ordem->order_link,
                    'url' => $res_ordem->order_link,
                    'min' => $res_ordem->order_quantidade,
                    'orderQuantity' => $res_ordem->order_quantidade,
                    'quantidade' => $res_ordem->order_quantidade,
                    'quantity' => $res_ordem->order_quantidade,
                    'quantityInterno' => $res_ordem->order_quantidade,
                    'max' => $res_ordem->order_quantidade,
                    'link' => $res_ordem->order_link,
                    'linkInterno' => $res_ordem->order_link,
                    'type' => $res_ordem->order_service_id,
                    'amount' => $res_ordem->order_quantidade,
                    'id_usuario' => $res_api->id_Usuario,
                ];
                $url = $res_api->link;
                $client = new Client;
                try {
                    $param_key = 'form_params';
                    if ($res_api->metodo === 'GET') {
                        $param_key = 'query';
                    }
                    $result = $client->request($res_api->metodo, $url, [
                        $param_key => $params,
                        'headers' => ['Accept' => 'application/json'],
                    ]);
                    $retorno = json_decode($result->getBody()->getContents(), true);
                    if (isset($retorno['order']) && $retorno['order'] != ""):
                        $retorno['order'] = $retorno['order'];
                    endif;
                    if (isset($retorno['id']) && $retorno['id'] != ""):
                        $retorno['order'] = $retorno['id'];
                    endif;
                    if (isset($retorno['id_pedido']) && $retorno['id_pedido'] != ""):
                        $retorno['order'] = $retorno['id_pedido'];
                    endif;
                    if (!empty($retorno['error'])):
                        if (!empty($retorno['error_message'])):
                            $retorno['error'] = $retorno['error'] . ' - ' . $retorno['error_message'];
                        endif;
                    endif;
                    if (!empty($retorno['errors'])):
                        if (!empty($retorno['error_message'])):
                            $retorno['error'] = $retorno['errors'] . ' - ' . $retorno['error_message'];
                        endif;
                    endif;
                    if (!empty($retorno['erro'])):
                        if (!empty($retorno['error_message'])):
                            $retorno['error'] = $retorno['erro'] . ' - ' . $retorno['error_message'];
                        endif;
                    endif;
                    if (!empty($retorno['mensagem'])):
                        $retorno['error'] = $retorno['mensagem'];
                    endif;
                    if (isset($retorno['order'])) {
                        $status = statusOrder($order_id, $res_ordem->order_id_api, $retorno['order']);
                        $retorno['status'] = $status['status'];
                    }
                    return $retorno;
                } catch (ClientException $e) {
                    
                }
            }
        }
    }
}
function statusOrder($order_id = 0, $idapi = 0, $id_order_api = null) {
    global $db, $pt;
    require $_SERVER['DOCUMENT_ROOT'] . '/admin/conexao/Helpers/GerenciadorAPI.class.php';
    $api = new GerenciadorAPI();
    $statusPedido = $api->status($idapi, $id_order_api);
    if (!empty($statusPedido['start_count'])):
        $inicial = $statusPedido['start_count'];
    elseif (!empty($statusPedido['quantidade_inicial'])):
        $inicial = $statusPedido['quantidade_inicial'];
    elseif (!empty($statusPedido['start'])):
        $inicial = $statusPedido['start'];
    elseif (!empty($statusPedido['start_counter'])):
        $inicial = $statusPedido['start_counter'];
    else:
        $inicial = 0;
    endif;
    if (!empty($statusPedido['remains'])):
        $final = $statusPedido['remains'];
    elseif (!empty($statusPedido['inserted'])):
        $final = $statusPedido['inserted'];
    elseif (!empty($statusPedido['quantity'])):
        $final = $statusPedido['inserted'];
    else:
        $final = 0;
    endif;
    if (isset($statusPedido['charge'])):
        $valorCustoServico = $statusPedido['charge'];
    elseif (isset($statusPedido['valor_pedido'])):
        $valorCustoServico = $statusPedido['valor_pedido'];
    else:
        $valorCustoServico = 0;
    endif;
    if (isset($statusPedido['status'])) {
        $update = $db->where('order_id', $order_id)->update('ws_ordens', array(
            'order_status' => strtoupper($statusPedido['status']),
            'order_custo' => $valorCustoServico,
            'order_qtd_inicial' => $inicial,
            'order_qtd_final' => $final,
            'order_id_ordem_api' => $id_order_api,
        ));
        $statusPedido['status'] = strtoupper($statusPedido['status']);
    }
    return $statusPedido;
}
function getApi($id = 0, $status = 1) {
    global $db, $pt;
    $api = $db->where('idapi', $id)->where('ativo', $status)->getOne("ws_api");
    if ($api) {
        $res_api = $api;
        if ($res_api->tipoapi == 'Brasil') {
            if (isset($res_api->paramAction)) {
                $res_api->paramAction = $res_api->paramAction;
            } else {
                $res_api->paramAction = 1;
            }
            $dados = $res_api;
        } else {
            if (isset($res_api->paramAction)) {
                $res_api->paramAction = $res_api->paramAction;
            } else {
                $res_api->paramAction = 'add';
            }
            $dados = $res_api;
        }
        return $dados;
    } else {
        return false;
    }
}
function UpdateDadosInstagram($string) {
    global $db, $pt;
    $instagram = new \InstagramScraper\Instagram();
    $account = $instagram->getAccount(UsuarioInstagram($string));
    return $account;
}
function GetOrdens() {
    global $pt, $db;
    $list = $db->rawQuery("select o.*, u.* from ws_ordens o, ws_users u where u.user_id = o.order_user_id");
    if ($list) {
        return $list;
    } else {
        return false;
    }
}
function GetOrdensUser($user_id = 0) {
    global $pt, $db;
    if (empty($user_id) && $user_id <= 0) {
        $list = $db->get("ws_ordens");
    } else {
        $list = $db->where('order_user_id', $user_id)->get("ws_ordens");
    }
    if ($list) {
        return $list;
    } else {
        return false;
    }
}
function SubtraiSaldo($user_id, $saldo) {
    global $db, $pt;
    $res = $db->where("user_id", $user_id)->getOne("ws_users");
    if ($res) {
        $array = array(
            'user_creditos' => ($res->user_creditos - $saldo),
        );
        $subtrai = $db->where("user_id", $user_id)->update("ws_users", $array);
        if ($subtrai) {
            return true;
        } else {
            return false;
        }
    }
}
function GetAssinaturaUser($user_id) {
    global $db, $pt;
    $assinatura = $db->rawQuery("select p.*,a.* from ws_posts p, ws_assinaturas a where a.customer_id = {$user_id} and a.plan_id = p.post_id order by p.post_title asc");
    if (isset($assinatura)) {
        return $assinatura;
    } else {
        return false;
    }
}
function CriaSessionUser($user_id) {
    global $db, $pt;
    $session = $db->where('user_id', $user_id)->getOne('ws_users');
    if ($session) {
        $_SESSION['userlogin'] = $session;
        return $session;
    } else {
        return false;
    }
}
function Insta_Privado_Texto($string) {
    if ($string == false) {
        $private = 'Publico';
    } else {
        $private = 'Privado';
    }
    return $private;
}
function Insta_Verificado_Texto($string) {
    if ($string == false) {
        $verified = 'Verificado';
    } else {
        $verified = 'Não verificado';
    }
    return $verified;
}
function Insta_Privado_Numero($string = false) {
    if ($string == false) {
        $private = 0;
    } else {
        $private = 1;
    }
    return $private;
}
function Insta_Verificado_Numero($string = false) {
    if ($string == false) {
        $verified = 0;
    } else {
        $verified = 1;
    }
    return $verified;
}
function CadastroUserInstagram($user_id, $string) {
    global $db, $pt;
    $account = UpdateDadosInstagram($string);
    $dados_instagram = array(
        'user_id' => $user_id,
        'instagram_id' => $account->getId(),
        'username' => $account->getUsername(),
        'full_name' => $account->getFullName(),
        'biography' => $account->getBiography(),
        'profile_picture_url' => $account->getProfilePicUrlHd(),
        'external_link' => $account->getExternalUrl(),
        'number_of_published_posts' => $account->getMediaCount(),
        'number_of_followers' => $account->getFollowsCount(),
        'number_of_follows' => $account->getFollowedByCount(),
        'is_private' => Insta_Privado_Numero($account->isPrivate()),
        'is_verified' => Insta_Verificado_Numero($account->isVerified()),
        'selected' => 1,
        'timestamp' => time(),
        'creditos' => 0,
    );
    $insert_instagram = $db->insert('ws_users_instagram', $dados_instagram);
    if ($insert_instagram) {
        return $insert_instagram;
    } else {
        return false;
    }
}
function cadastroUser(array $dados) {
    global $db, $pt;
    $dados_cadastro = array(
        'user_name' => $dados['user_name'],
        'user_email' => $dados['user_email'],
        'user_instagram' => $dados['user_instagram'],
        'user_password' => md5($dados['user_password']),
        'user_registration' => date('Y-m-d H:i:s'),
        'user_status' => 1,
        'user_level' => 4,
        'user_creditos' => 0,
    );
    $insert = $db->insert('ws_users', $dados_cadastro);
    if ($insert) {
        return $insert;
    } else {
        return false;
    }
}
function categories_home($type = 'posts', $limite = 0) {
    global $pt, $db;
    //$categories = $db->where("type",$type)->where("category_name","sem-categoria","!=")->get("ws_categories",$limite);
    if ($limite == 0) {
        $categories = $db->rawQuery("select t.*,c.* from ws_term_taxonomy t, ws_terms c where t.term_id = c.term_id and t.parent = 0 and c.slug != 'sem-categoria' and t.type = '{$type}' order by c.term_order asc");
    } else {
        $categories = $db->rawQuery("select t.*,c.* from ws_term_taxonomy t, ws_terms c where t.term_id = c.term_id and t.parent = 0 and c.slug != 'sem-categoria' and t.type = '{$type}' order by c.term_order asc limit {$limite}");
    }
    if ($categories) {
        return $categories;
    } else {
        return false;
    }
}
function relationships_products_category($catId = 0, $limite = 0) {
    global $pt, $db;
    //$categories = $db->where("type",$type)->where("category_name","sem-categoria","!=")->get("ws_categories",$limite);
    //$categories = $db->rawQuery("select t.*,c.* from ws_term_taxonomy t, ws_terms c where t.term_id = c.term_id and c.slug != 'sem-categoria' and t.type = '{$type}' order by c.name asc limit {$limite}");
    if ($limite == 0) {
        $categories = $db->rawQuery("select * from ws_term_relationships where term_taxonomy_id = {$catId} order by term_order asc");
    } else {
        $categories = $db->rawQuery("select * from ws_term_relationships where term_taxonomy_id = {$catId} order by term_order asc limit {$limite}");
    }
    if ($categories) {
        return $categories;
    } else {
        return false;
    }
}
function list_products_category($post_id = 0, $type = 'produtos') {
    global $pt, $db;
    $product = $db->where('post_id', $post_id)->where('post_type', $type)->where('post_status', 1)->getOne("ws_posts");
    if ($product) {
        if ($product->post_valor <= 0.01) {
            $product->post_valor = 'Sob consulta';
        }
        return $product;
    } else {
        return false;
    }
}
function products($type = 'produtos', $limite = 0, $order = 'asc', $status = 1) {
    global $pt, $db;
    if ($limite == 0) {
        $product = $db->orderBy('post_ordem', $order)->where('post_type', $type)->where('post_status', $status)->get("ws_posts");
    } else {
        $product = $db->orderBy('post_ordem', $order)->where('post_type', $type)->where('post_status', $status)->get("ws_posts", $limite);
    }
    if ($product) {
        return $product;
    } else {
        return false;
    }
}
function PT_SendMessage($data = array(), $files = array()) {
    global $pt, $db, $mail;
    $email_from = $data['from_email'] = PT_Secure($data['from_email']);
    $to_email = $data['to_email'] = PT_Secure($data['to_email']);
    $subject = $data['subject'];
    $data['charSet'] = PT_Secure($data['charSet']);
    if ($pt->config->smtp_or_mail == 'mail') {
        $mail->IsMail();
    } else if ($pt->config->smtp_or_mail == 'smtp') {
        $mail->isSMTP();
        $mail->Host = $pt->config->smtp_host;
        $mail->SMTPAuth = true;
        $mail->Username = $pt->config->smtp_username;
        $mail->Password = $pt->config->smtp_password;
        $mail->SMTPSecure = $pt->config->smtp_encryption;
        $mail->Port = $pt->config->smtp_port;
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );
    } else {
        return false;
    }
    $mail->IsHTML($data['is_html']);
    $mail->setFrom($data['from_email'], $data['from_name']);
    $mail->addAddress($data['to_email'], $data['to_name']);
    $mail->Subject = $data['subject'];
    $mail->CharSet = $data['charSet'];
    if ($files) {
        $mail->addAttachment($files);
    }
    $mail->MsgHTML($data['message_body']);
    if ($mail->send()) {
        $mail->ClearAddresses();
        return true;
    }
}
function gallery_post($post_id = 0, $limite = 0, $type = 'image/jpeg', $gallery_type = 0, $ordem = 'asc') {
    global $pt, $db;
    if ($limite == 0) {
        $gallery = $db->where('post_id', $post_id)->where('gallery_type', $gallery_type)->orderBy('ordem', $ordem)->get('ws_posts_gallery');
    } else {
        $gallery = $db->where('post_id', $post_id)->where('gallery_type', $gallery_type)->orderBy('ordem', $ordem)->get('ws_posts_gallery', $limite);
    }
    if ($gallery) {
        if (!empty($type) && $type == 'application/pdf') {
            return false;
            exit();
        }
        return $gallery;
    } else {
        return false;
    }
}
function list_catalogo_post($post_id = 0, $type = 'application/pdf') {
    global $pt, $db;
    $catalogo = $db->where('post_id', $post_id)->where('type', $type)->getOne('ws_posts_gallery');
    if ($catalogo) {
        return $catalogo;
    } else {
        return false;
    }
}
function delete_gallery_posts($post_id = 0) {
    global $pt, $db;
    $gallerys = $db->where('post_id', $post_id)->get('ws_posts_gallery');
    if (!empty($gallerys)) {
        foreach ($gallerys as $key => $gallery) {
            if (!empty($gallery->gallery_image)) {
                if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $gallery->gallery_image)) {
                    unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $gallery->gallery_image);
                }
            }
            if (!empty($gallery->gallery_image_capa)) {
                if (file_exists($_SERVER['DOCUMENT_ROOT'] . '/' . $gallery->gallery_image_capa)) {
                    unlink($_SERVER['DOCUMENT_ROOT'] . '/' . $gallery->gallery_image_capa);
                }
            }
            $delete = $db->where('post_id', $post_id)->delete('ws_posts_gallery');
        }
    }
}
function pegaModelo($id = 0) {
    global $pt, $db;
    $modelo = $db->where('modelo_id', $id)->where('modelo_status', 1)->getOne('ws_modelos');
    if ($modelo) {
        return $modelo;
    } else {
        return false;
    }
}
function toJson($data) {
    header('Content-Type: application/json');
    return json_encode($data);
}
function banners() {
    global $db, $pt;
    $list = $db->where('post_type', 'banners')->get('ws_posts');
    if ($list) {
        return $list;
    } else {
        return false;
    }
}
