<?php

/**
 * Login.class [ MODEL ]
 * Responável por autenticar, validar, e checar usuário do sistema de login!
 * 
* @copyright (c) 2015, Alisson Maciel AGÊNCIA DIGITAL WEB LAB
 */
class LoginClientes {

    private $Level;
    private $Email;
    private $Senha;
    private $Error;
    private $Result;
    private $Tabela;
    private $Prefixo = PREFIX;

    /**
     * <b>Informar Level:</b> Informe o nível de acesso mínimo para a área a ser protegida.
     * @param INT $Level = Nível mínimo para acesso
     */
    function __construct($Tabela) {
        $this->Tabela = $Tabela;
    }

    /**
     * <b>Efetuar Login:</b> Envelope um array atribuitivo com índices STRING user [email], STRING pass.
     * Ao passar este array na ExeLogin() os dados são verificados e o login é feito!
     * @param ARRAY $UserData = user [email], pass
     */
    public function ExeLogin(array $UserData) {
        $funcoes = new Funcoes();
        $this->Email = (string) $funcoes->anti_injection($UserData['emailCliente']);
        $this->Senha = (string) $funcoes->anti_injection($UserData['senhaCliente']);
        $this->setLogin();
    }

    /**
     * <b>Verificar Login:</b> Executando um getResult é possível verificar se foi ou não efetuado
     * o acesso com os dados.
     * @return BOOL $Var = true para login e false para erro
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e um tipo de erro WS_.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /**
     * <b>Checar Login:</b> Execute esse método para verificar a sessão USERLOGIN e revalidar o acesso
     * para proteger telas restritas.
     * @return BOLEAM $login = Retorna true ou mata a sessão e retorna false!
     */
    public function CheckLogin() {
        if (empty($_SESSION[$this->Prefixo . 'userlogin'])):
            unset($_SESSION[$this->Prefixo . 'userlogin']);
            return false;
        else:
            return true;
        endif;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Valida os dados e armazena os erros caso existam. Executa o login!
    private function setLogin() {
        $Check = new Check;
        if (!$this->Email || !$this->Senha || !$Check->Email($this->Email)):
            $this->Error = ['Informe seu E-mail e senha para efetuar o login!', WS_INFOR];
            $this->Result = false;
        elseif (!$this->getUser()):
            $this->Error = ['Os dados informados não são compatíveis!', WS_ALERT];
            $this->Result = false;

        else:
            $this->Execute();
        endif;
    }

    //Vetifica usuário e senha no banco de dados!
    private function getUser() {
        $this->Senha = md5($this->Senha);

        $read = new Read;
        $read->ExeRead($this->Tabela, "WHERE emailCliente = :e AND senhaCliente = :s AND statusCliente = :number", "e={$this->Email}&s={$this->Senha}&number=1");

        if ($read->getResult()):
            $this->Result = $read->getResult()[0];
            return true;
        else:
            return false;
        endif;
    }

    //Executa o login armazenando a sessão!
    private function Execute() {
        if (!session_id()):
            session_start();
        endif;

        $_SESSION[$this->Prefixo . 'userlogin'] = $this->Result;

        $this->Error = ["Olá {$this->Result->nomeCliente}, seja bem vindo(a). Aguarde redirecionamento!", WS_ACCEPT];
        $this->Result = true;
    }

    public function isLogado() {
        if (isset($_SESSION[$this->Prefixo . 'userlogin'])):
            return true;
        else:
            return false;
        endif;
    }

    public function deslogar() {

        if ($this->isLogado()):
            unset($_SESSION[$this->Prefixo . 'userlogin']);
            $this->Result = true;
            $funcoes->redirect(BASE);
        else:
            $this->Result = false;
        endif;
    }

    public function recuperaSessao() {
        $read = new Read;
        $read->ExeRead("loja_clientes", "where emailCliente = :email and senhaCliente = :senha", "email={$_SESSION[PREFIX . 'userlogin']->emailCliente}&senha={$_SESSION[PREFIX . 'userlogin']->senhaCliente}");
        if ($read->getResult()):
            return $read->getResult()[0];
        endif;
    }

}
