<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of AdminFilme
 *
 * @author WEBLAB
 */
class AdminFilme {

    private $Data;
    private $Post;
    private $Error;
    private $Result;

    const Entity = "medien";

    public function ExeCreate(array $Data) {
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Create();
    }

    public function ExeUpdate($PostId, array $Data) {
        $this->Post = (int) $PostId;
        $this->Data = $Data;

        $this->setData();
        $this->setName();
        $this->Update();
    }

    public function ExeDelete($PostId) {
        $this->Post = (int) $PostId;

        $ReadPost = new Read;
        $ReadPost->ExeRead(self::Entity, "WHERE tombo = :codigo", "codigo={$this->Post}");

        if (!$ReadPost->getResult()):
            $this->Error = ["Os dados que você tentou deletar não existe no sistema!", WS_ERROR];
            $this->Result = false;
        else:
            $PostDelete = $ReadPost->getResult()[0];

            $deleta = new Delete;
            $deleta->ExeDelete(self::Entity, "WHERE tombo = :cod", "cod={$this->Post}");

            $this->Error = ["Os dados foram removidos com sucesso do sistema!", WS_ACCEPT];
            $this->Result = true;

        endif;
    }

    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com uma mensagem e o tipo de erro.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    private function setData() {

        $check = new Check;
        $this->Data = array_map("strip_tags", $this->Data);
        $this->Data = array_map("trim", $this->Data);
        $this->Data['data_de_catalogo'] = $check->Data($this->Data['data_de_catalogo']);
    }

    //Verifica o NAME post. Se existir adiciona um pÃ³s-fix -Count
    private function setName() {
        $Where = (isset($this->Post) ? "tombo != {$this->Post} AND" : '');
        $readName = new Read;
        $readName->ExeRead(self::Entity, "WHERE {$Where} titulooriginal = :o", "o={$this->Data['titulooriginal']}");
        if ($readName->getResult()):
            $this->Data['titulooriginal'] = $this->Data['titulooriginal'] . '-' . $readName->getRowCount();
        endif;
    }

    private function Create() {
        $cadastra = new Create();
        $cadastra->ExeCreate(self::Entity, $this->Data);
        if ($cadastra->getResult()):
            $this->Error = ["Cadastro realizado com sucesso no sistema!", WS_ACCEPT];
            $this->Result = $cadastra->getResult();
        endif;
    }

    private function Update() {
        $Update = new Update();
        $Update->ExeUpdate(self::Entity, $this->Data, "where tombo = :cod", "cod={$this->Post}");
        if ($Update->getResult()):
            $this->Error = ["Dados atualizados com sucesso no sistema!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
