<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of UserAgents
 *
 * @author WEBLAB
 */
class Traffic {

    private $ip;
    private $data;
    private $uri;
    private $user_agent;
    private $Class_Agent;

    public function __construct() {
        $funcoes = new Funcoes;
        $this->uri = $_SERVER['REQUEST_URI'];
        $this->ip = $_SERVER['REMOTE_ADDR'];
        $this->user_agent = $_SERVER['HTTP_USER_AGENT'];
        $this->Class_Agent = new UserAgents();
        if (!isset($_COOKIE[md5($this->uri)])):
            $this->_set_cookie();
            $this->_set_data();
        endif;
    }

    private function _set_cookie() {
        setcookie(md5($this->uri), TRUE, time() + strtotime(date('Y-m-d 23:59:59')) - time());
    }

    private function _set_data() {

        $geo = json_decode(file_get_contents("http://ip-api.com/json/{$this->ip}"));

        $this->data['data'] = date('Y-m-d H:i:s');
        $this->data['pagina'] = $this->uri;
        $this->data['ip'] = $this->ip;
        $this->data['cidade'] = (isset($geo->city)) ? $geo->city : 'Desconhecida';
        $this->data['regiao'] = (isset($geo->regionName)) ? $geo->regionName : 'Desconhecida';
        $this->data['pais'] = (isset($geo->country)) ? $geo->country : 'Desconhecido';
        $this->data['navegador'] = $this->_get_browser();
        $this->data['plataforma'] = $this->_get_platforms();
        $this->data['referencia'] = $this->_get_referer();

        $this->_rec_data();
    }

    private function _get_browser() {
        foreach ($this->Class_Agent->browsers() as $key => $value):
            if (preg_match('|' . $key . '.*?([0-9\.]+)|i', $this->user_agent)):
                return $value;
            endif;
        endforeach;
    }

    private function _get_platforms() {
        foreach ($this->Class_Agent->platforms() as $key => $value):
            if (preg_match('|' . preg_quote($key) . '|i', $this->user_agent)):
                return $value;
            endif;
        endforeach;
    }

    private function _get_mobiles() {
        foreach ($this->Class_Agent->mobiles() as $key => $value):
            return $value;
        endforeach;
    }

    private function _get_robots() {
        foreach ($this->Class_Agent->robots() as $key => $value):
            return $value;
        endforeach;
    }

    private function _get_referer() {
        $referer = (isset($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : 'Acesso direto ou desconhecido';
        $referer_host = parse_url($referer, PHP_URL_HOST);
        $host = $_SERVER['SERVER_NAME'];

        if ($referer_host == $host):
            $retorno = 'Navegação interna';
        endif;

        $retorno = $referer;
        return $retorno;
    }

    private function _rec_data() {
        $create = new Create();
        $create->ExeCreate("ws_trafego", $this->data);
    }

}
