<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Ordens
 *
 * @author aliss
 */
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;

class Ordens {

    private $Result;
    private static $id;

    public static function getOrdens() {
        global $db, $prefix;
        $res = $db->rawQuery("SELECT "
                . "tbl_ordens.idOrdem,tbl_ordens.idordemapi,tbl_ordens.dataOrdem,tbl_ordens.obsOrdem,tbl_ordens.nameServico,tbl_ordens.quantidadeInicial,tbl_ordens.quantidadeFinal,"
                . "tbl_ordens.qtUnitariaServico,tbl_ordens.valorTotalServico,tbl_ordens.linkServico,tbl_ordens.statusOrdem,tbl_ordens.idapi,"
                . "tbl_usuario.login,tbl_usuario.id,"
                . "tbl_servicos.nome,"
                . "tbl_categorias.descricao "
                . "FROM "
                . "tbl_ordens, "
                . "tbl_usuario, "
                . "tbl_servicos, "
                . "tbl_categorias "
                . "where "
                . "tbl_ordens.idservico = tbl_servicos.idservico "
                . "and "
                . "tbl_ordens.idUsuario = tbl_usuario.idUsuario "
                . "and "
                . "tbl_servicos.idservico = tbl_ordens.idServico "
                . "and "
                . "tbl_categorias.idcategoria = tbl_servicos.idcategoria "
                . "order by "
                . "tbl_ordens.idOrdem desc");


        $dados = array(
            'conta' => count($res),
            'res' => $res
        );
        return $dados;
    }

    public static function OrderUser(array $array) {
        global $db;
        $orderUser = $db->where('idOrdem', $array['order'])->where('idUsuario', $array['usuario'])->getOne('tbl_ordens');
        return $orderUser;
    }

    public static function setOrders($id) {
        global $db,$pt;

        $res = $db->rawQuery("select * from tbl_ordens where idOrdem = " . $id . " AND idordemapi IS NULL AND statusOrdem = '" . $status . "'");
        $params = $params;

        if ($res):

            $res_ordem = $res[0];

            $res_servico = Packages::services($res_ordem->idServico);

            if ($res_servico):

                $res_api = self::setAPI($res_servico->idapi);

                if ($res_api):

                    $params = [
                        'apiKey' => $res_api->token,
                        'api_token' => $res_api->token,
                        'token' => $res_api->token,
                        'keyInterno' => $res_api->token,
                        'actionType' => $res_api->paramAction,
                        'action' => $res_api->paramAction,
                        'actionInterno' => $res_api->paramAction,
                        'id_usuario' => $res_api->id_Usuario,
                        'key' => $res_api->token,
                        'orderType' => $res_servico->idservicoapi,
                        'package' => $res_servico->idservicoapi,
                        'tipo' => $res_api->paramAction,
                        'id_produto' => $res_servico->idservicoapi,
                        'service' => $res_servico->idservicoapi,
                        'serviceInterno' => $res_servico->idservicoapi,
                        'orderUrl' => $res_ordem->linkServico,
                        'username' => $res_ordem->linkServico,
                        'url' => $res_ordem->linkServico,
                        'min' => $res_ordem->qtUnitariaServico,
                        'orderQuantity' => $res_ordem->qtUnitariaServico,
                        'quantidade' => $res_ordem->qtUnitariaServico,
                        'quantity' => $res_ordem->qtUnitariaServico,
                        'quantityInterno' => $res_ordem->qtUnitariaServico,
                        'max' => $res_ordem->qtUnitariaServico,
                        'posts' => $res_ordem->posts,
                        'delay' => $res_ordem->delay,
                        'gender' => $res_ordem->gender,
                        'runs' => $res_ordem->runs,
                        'interval' => $res_ordem->intervalo,
                        'comment_strings' => $res_ordem->comentarios,
                        'comments' => $res_ordem->comentarios,
                        'link' => $res_ordem->linkServico,
                        'linkInterno' => $res_ordem->linkServico,
                        'custom_data' => $res_ordem->comentarios,
                        'type' => $res_servico->idservicoapi,
                        'amount' => $res_ordem->qtUnitariaServico,
                        'custom_comments' => $res_ordem->comentarios,
                        'id_usuario' => $res_ordem->id_Usuario,
                        'qntd_fotos' => $res_ordem->posts,
                        'timer' => $res_ordem->delay,
                        'msgs' => $res_ordem->comentarios,
                    ];
                
                    $url = $res_api->link;
                    $client = new Client;
                  
                    try {

                        $param_key = 'form_params';
                        if ($res_api->metodo === 'GET') {
                            $param_key = 'query';
                        }

                        $result = $client->request($res_api->metodo, $url, [
                            $param_key => $params,
                            'headers' => ['Accept' => 'application/json'],
                        ]);
                   
                        $retorno = json_decode($result->getBody()->getContents(), true);

                        if (isset($retorno['order']) && $retorno['order'] != ""):
                            $retorno['order'] = $retorno['order'];
                        endif;
                        if (isset($retorno['id']) && $retorno['id'] != ""):
                            $retorno['order'] = $retorno['id'];
                        endif;
                        if (isset($retorno['id_pedido']) && $retorno['id_pedido'] != ""):
                            $retorno['order'] = $retorno['id_pedido'];
                        endif;

                        if (!empty($retorno['error'])):
                            if (!empty($retorno['error_message'])):
                                $erro = $retorno['error'] . ' - ' . $retorno['error_message'];
                            endif;
                        endif;
                        if (!empty($retorno['errors'])):
                            if (!empty($retorno['error_message'])):
                                $erro = $retorno['errors'] . ' - ' . $retorno['error_message'];
                            endif;
                        endif;

                        if (!empty($retorno['erro'])):
                            if (!empty($retorno['error_message'])):
                                $erro = $retorno['erro'] . ' - ' . $retorno['error_message'];
                            endif;
                        endif;
                        if (!empty($retorno['mensagem'])):
                            $erro = $retorno['mensagem'];
                        endif;

                        if (isset($retorno['order']) || isset($retorno['id']) || isset($retorno['id_pedido'])) {
                            $noFornecedor = 'SimFornecedor';
                            $reenviar = 1;

                            $array_update = [
                                'idordemapi' => $retorno['order'],
                                'idapi' => $res_ordem->idapi,
                                'noFornecedor' => $noFornecedor,
                                'reenviar' => $reenviar
                            ];
                            $update = $db->where('idOrdem', $res_ordem->idOrdem)->update('tbl_ordens', $array_update);

                            $linhaServicos = $db->where('idOrdem', $res_ordem->idORdem)->getOne('tbl_ordens');

                            if ($linhaServicos):
                                $linhaServicos = (array) $linhaServicos;
                            else:
                                $linhaServicos = (array) $res_ordem;
                            endif;
                            $statusPedido = $api->status($linhaServicos['idapi'], $linhaServicos['idordemapi']);

                            if (!empty($statusPedido['start_count'])):
                                $inicial = $statusPedido['start_count'];
                            elseif (!empty($statusPedido['quantidade_inicial'])):
                                $inicial = $statusPedido['quantidade_inicial'];
                            elseif (!empty($statusPedido['start'])):
                                $inicial = $statusPedido['start'];
                            elseif (!empty($statusPedido['start_counter'])):
                                $inicial = $statusPedido['start_counter'];
                            else:
                                $inicial = 0;
                            endif;
                            if (!empty($statusPedido['remains'])):
                                $final = $statusPedido['remains'];
                            elseif (!empty($statusPedido['inserted'])):
                                $final = $statusPedido['inserted'];
                            elseif (!empty($statusPedido['quantity'])):
                                $final = $statusPedido['inserted'];
                            else:
                                $final = 0;
                            endif;
                            if (isset($statusPedido['status'])) {

                                if ($linhaServicos['typeServico'] == "Subscriptions") {
                                    $valorCustoServico = 0;
                                } else {

                                    if (isset($statusPedido['charge'])):
                                        $valorCustoServico = $statusPedido['charge'];
                                    elseif (isset($statusPedido['valor_pedido'])):
                                        $valorCustoServico = $statusPedido['valor_pedido'];
                                    else:
                                        $valorCustoServico = 0;
                                    endif;
                                }
                                $reembolsado = 0;
                                if (!empty($linhaServicos['reembolsado']) && $linhaServicos['reembolsado'] > 0):
                                else:
                                    if ($statusPedido['status'] == "Canceled" || $statusPedido['status'] == "Cancelled" || $statusPedido['status'] == 3 || $statusPedido['status'] == 6) {
                                        $user_home->AdicionarSaldo($linhaServicos['idUsuario'], $linhaServicos['valorTotalServico'], "Ordem " . $linhaServicos['idOrdem'] . " cancelada", "Reembolsado");
                                        $reembolsado == 1;
                                        $Dados['idordemapi'] = 'Reembolsado';
                                    }
                                    if ($statusPedido['status'] == "Partial" || $statusPedido['status'] == 3 || $statusPedido['status'] == 6) {
                                        $user_home->AdicionarSaldo($linhaServicos['idUsuario'], (($linhaServicos['valorTotalServico'] / $linhaServicos['qtUnitariaServico']) * $statusPedido['remains']), "Ordem " . $linhaServicos['idOrdem'] . " realizada parcialmente", "Reembolsado");
                                        $reembolsado == 1;
                                        $Dados['idordemapi'] = 'Reembolsado';
                                    }

                                endif;

                                if ($statusPedido['status'] == "Completed" || $statusPedido['status'] == "Partial" || $statusPedido['status'] == "Canceled" || $statusPedido['status'] == 2 || $statusPedido['status'] == 1) {
                                    $array_update = [
                                        'dtconclusao' => date('Y-m-d H:i:s')
                                    ];

                                    $update = $db->where('idOrdem', $linhaServicos['idOrdem'])->update('tbl_ordens', $array_update);
                                }

                                $array_update = [
                                    'statusOrdem' => $statusPedido['status'],
                                    'idordemapi' => $Dados['idordemapi'],
                                    'reembolsado' => $reembolsado,
                                    'quantidadeFinal' => $final,
                                    'reenviar' => $r,
                                    'valorCustoServico' => number_format($valorCustoServico, 2),
                                    'quantidadeInicial' => $inicial
                                ];

                                $update = $db->where('idOrdem', $linhaServicos['idOrdem'])->update('tbl_ordens', $array_update);
                            }
                        } else {
                            $noFornecedor = 'noFornecedor';

                            $array_update = [
                                'idapi' => $linhaServicos['idapi'],
                                'noFornecedor' => $noFornecedor,
                                'obsOrdem' => $erro
                            ];

                            $update = $db->where('idOrdem', $linhaServicos['idOrdem'])->update('tbl_ordens', $array_update);
                        }
                    } catch (ClientException $e) {

                    }



                endif;

            endif;


        endif;
    }

    public static function setAPI($id, $status = 1) {
        global $db;
        $api = $db->where('idapi', $id)->where('ativo', $status)->getOne("tbl_api");

        if ($api):
            $res_api = $api;
            if ($res_api->tipoapi == 'Brasil'):

                if (isset($res_api->paramAction)) {
                    $res_api->paramAction = $res_api->paramAction;
                } else {
                    $res_api->paramAction = 1;
                }

                $dados = $res_api;

            else:

                if (isset($res_api->paramAction)) {
                    $res_api->paramAction = $res_api->paramAction;
                } else {
                    $res_api->paramAction = 'add';
                }

                $dados = $res_api;

            endif;

            return $dados;

        endif;
    }

    public static function Status($id) {
        global $db;
        $read = new Read;
        $create = new Create();

        self::$id = (int) $id;

        if (self::$id):
            /* ORDER */
            $order = $db->rawQuery("select tbl_ordens.*,tbl_servicos.idservicoapi FROM tbl_ordens, tbl_servicos where tbl_ordens.idServico = tbl_servicos.idservico and idOrdem = " . self::$id);

            if ($order):
                $order = (array) $order[0];

                /* API */
                $res_api = self::setAPI($order['idapi'], 1);

                if ($res_api):

                    $params = [
                        'package' => $order['idservicoapi'],
                        'api_token' => $res_api->token,
                        'apiKey' => $res_api->token,
                        'key' => $res_api->token,
                        'keyInterno' => $res_api->token,
                        'token' => $res_api->token,
                        'actionType' => $res_api->paramAction,
                        'action' => $res_api->paramAction,
                        'actionInterno' => $res_api->paramAction,
                        'tipo' => 'REALIZAR_PEDIDO',
                        'id_usuario' => $res_api->id_Usuario,
                        'id_produto' => $order['idservicoapi'],
                        'orderType' => $order['idservicoapi'],
                        'service' => $order['idservicoapi'],
                        'serviceInterno' => $order['idservicoapi'],
                        'username' => $order['linkServico'],
                        'orderUrl' => $order['linkServico'],
                        'url' => $order['linkServico'],
                        'min' => $order['qtUnitariaServico'],
                        'quantidade' => $order['qtUnitariaServico'],
                        'orderQuantity' => $order['qtUnitariaServico'],
                        'quantity' => $order['qtUnitariaServico'],
                        'quantityInterno' => $order['qtUnitariaServico'],
                        'max' => $order['qtUnitariaServico'],
                        'posts' => $order['posts'],
                        'delay' => $order['delay'],
                        'gender' => $order['gender'],
                        'runs' => $order['runs'],
                        'interval' => $order['intervalo'],
                        'comment_strings' => $order['comentarios'],
                        'comments' => $order['comentarios'],
                        'custom_data' => $order['comentarios'],
                        'link' => $order['linkServico'],
                        'linkInterno' => $order['linkServico'],
                        'qntd_fotos' => $order['posts'],
                        'timer' => $order['delay'],
                        'msgs' => $order['comentarios'],
                    ];

                    $url = $res_api->link;
                    $client = new Client;

                    if (!empty($res_api->order_success_response) && $res_api->order_success_response != ''):
                        $res_api->order_success_response = $res_api->order_success_response;

                        try {
                            $param_key = 'form_params';
                            if ($res_api->metodo === 'GET') {
                                $param_key = 'query';
                            }

                            $result = $client->request($res_api->metodo, $url, [
                                $param_key => $params,
                                'headers' => ['Accept' => 'application/json'],
                            ]);

                            if ($result->getStatusCode() === 200) {
                                $retorno = $result->getBody()->getContents();
                                $retorno2 = json_decode($result->getBody()->getContents(), true);

                                $success_response = array_cast_recursive(json_decode($res_api->order_success_response));
                                $r = json_decode($retorno);

                                if (isset($r->{$res_api->order_id_key}) && $r->{$res_api->order_id_key} != ''):
                                    $params = [
                                        'idapi' => $res_api->idapi,
                                        'idordemapi' => $r->{$res_api->order_id_key},
                                        'statusOrdem' => 'Processing',
                                    ];
                                    self::UpdateOrdem(self::$id, $params);

                                    $Dados = [
                                        'user_id' => $order['idUsuario'],
                                        'user_status' => 'Usuário',
                                        'log_data' => date('Y-m-d H:i:s'),
                                        'observacao' => $retorno,
                                        'type' => 'log_erro',
                                        'ordem_id' => self::$id
                                    ];
                                    $insert = $db->insert('tbl_logs', $Dados);

                                    $code_erro = 'success';
                                    return json_encode([
                                        'success' => true,
                                        'message' => 'Success! Order placed successfully!',
                                        'css_class' => 'alert-success',
                                        'msg' => 'Ordem #' . self::$id . ' realizada com sucesso. <br>'
                                        . '<strong>Serviço: ' . $order['nameServico'] . '</strong> <br>'
                                        . '<strong>Valor: R$ ' . $order['valorTotalServico'] . '</strong> <br>'
                                        . '<strong>Quantidade: ' . $order['qtUnitariaServico'] . '</strong> <br>'
                                        . '<strong>Status: Processing</strong> <br>'
                                        . '<a href="/minhas-ordens.php">Clique Aqui</a> para acompanhar o andamento.', 'code' => $code_erro
                                    ]);
                                else:

                                    $Dados = [
                                        'user_id' => $order['idUsuario'],
                                        'user_status' => 'Usuário',
                                        'log_data' => date('Y-m-d H:i:s'),
                                        'observacao' => $retorno,
                                        'type' => 'log_erro',
                                        'ordem_id' => self::$id
                                    ];
                                    $insert = $db->insert('tbl_logs', $Dados);

                                    $code_erro = 'danger';
                                    $erro = '';

                                    if (!empty($retorno2['error'])):
                                        $erro = $retorno2['error'];
                                        if (!empty($retorno2['error_message'])):
                                            $erro = $retorno2['error'] . ' - ' . $retorno2['error_message'];
                                        endif;
                                    endif;
                                    if (!empty($retorno2['errors'])):
                                        $erro = $retorno2['errors'];
                                        if (!empty($retorno2['error_message'])):
                                            $erro = $retorno2['errors'] . ' - ' . $retorno2['error_message'];
                                        endif;
                                    endif;

                                    if (!empty($retorno2['erro'])):
                                        $erro = $retorno2['erro'];
                                        if (!empty($retorno2['error_message'])):
                                            $erro = $retorno2['erro'] . ' - ' . $retorno2['error_message'];
                                        endif;
                                    endif;
                                    if (!empty($retorno2['mensagem'])):
                                        $erro = $retorno2['mensagem'];
                                    endif;
                                    $params = [
                                        'statusOrdem' => 'Pending',
                                    ];
                                    self::UpdateOrdem(self::$id, $params);
                                    return json_encode([
                                        'success' => false,
                                        'message' => 'Failed! Please see response logs.',
                                        'css_class' => 'alert-danger',
                                        'msg' => 'A ordem #' . self::$id . ', deu falha! <br>'
                                        . '<strong>Serviço: ' . $order['nameServico'] . '</strong> <br>'
                                        . '<strong>Valor: R$ ' . $order['valorTotalServico'] . '</strong> <br>'
                                        . '<strong>Quantidade: ' . $order['qtUnitariaServico'] . '</strong> <br>'
                                        . '<strong>Status: Pending</strong> <br>'
                                        . '<strong>Motivo: ' . strip_tags(trim($erro)) . '</strong> <br>'
                                        . '<a href="/minhas-ordens.php">Clique Aqui</a> para ver suas ordens.', 'code' => $code_erro
                                    ]);

                                endif;
                            }
                        } catch (ClientException $e) {
                            echo '<pre>';
                            var_dump('catch: ' . $e);
                            echo '</pre>';
                        }

                    else:
//                        return json_encode([
//                            'msg' => 'Não foi possível enviar a ordem! <br>'
//                            . '<strong>Status: Refunded (Reembolsado)</strong> <br>'
//                            . "Entre em contato com o administrador e solicite que ele verifique o cadastro das API's", 'code' => 'danger'
//                        ]);
                        $params = [
                            'idapi' => $res_api->idapi,
                            'statusOrdem' => 'Pending',
                        ];
                        self::UpdateOrdem(self::$id, $params);

                        $Dados = [
                            'user_id' => $order['idUsuario'],
                            'user_status' => 'Usuário',
                            'log_data' => date('Y-m-d H:i:s'),
                            'observacao' => "",
                            'type' => 'log_erro',
                            'ordem_id' => self::$id
                        ];
                        $insert = $db->insert('tbl_logs', $Dados);
                        die();
                        exit();
                    endif;
                endif;
            endif;

        endif;
    }

    public static function UpdateOrdem($id, array $params) {
        global $db;
        self::$id = $id;
        $params = (array) $params;

        $db->where('idOrdem', self::$id)->update("tbl_ordens", $params);
    }

}
