<?php

class GerenciadorAPI {

    public function order($idapi, $dados) {

        $linhaApi = $this->obterApi($idapi);

        if (!empty($linhaApi['id_Usuario'])):
            $id = $linhaApi['id_Usuario'];
        else:
            $id = 0;
        endif;

        if (!empty($linhaApi['statusParam'])):
            $statusParam = $linhaApi['statusParam'];
        else:
            $statusParam = 0;
        endif;

        if (!empty($linhaApi['saldoParam'])):
            $saldoParam = $linhaApi['saldoParam'];
        else:
            $saldoParam = 0;
        endif;

        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Padrao") {
            $api = new ApiPadrao($linhaApi['link'], $linhaApi['token'], $id, null, $statusParam, $saldoParam);
            return $api->order($dados);
        }
        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Brasil") {
            if (isset($dados['comments'])):
                $dados['msgs'] = $dados['comments'];
            endif;

            $apis = new ApiBrasil($linhaApi['link'], $linhaApi['token'], $id, $statusParam, $saldoParam);
            $temp = $apis->order($dados);
            $retorno = array();
            if (isset($temp['id'])):
                $retorno['order'] = $temp['id'];
            endif;

            return $retorno;
        }
    }

    public function status($idapi, $idordemapi) { // get order status
        $linhaApi = $this->obterApi($idapi);

        if (!empty($linhaApi['id_Usuario'])):
            $id = $linhaApi['id_Usuario'];
        else:
            $id = 0;
        endif;

        if (!empty($linhaApi['statusParam'])):
            $statusParam = $linhaApi['statusParam'];
        else:
            $statusParam = 0; 
        endif;

        if (!empty($linhaApi['saldoParam'])):
            $saldoParam = $linhaApi['saldoParam'];
        else:
            $saldoParam = 0;
        endif;
        

        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Padrao") {
            $api = new ApiPadrao($linhaApi['link'], $linhaApi['token'], $id, null, $statusParam, $saldoParam);
            return $api->status($idordemapi);
        } else if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Brasil") {

            $api = new ApiBrasil($linhaApi['link'], $linhaApi['token'], $id, $statusParam, $saldoParam);
            $temp = $api->status($idordemapi);
            $retorno = Array();
            if (isset($temp['charge'])):
                $retorno['charge'] = $temp['charge'];
            endif;

            if (isset($temp['start'])):
                $retorno['start_count'] = $temp['start'];
            endif;
            if (isset($temp['status'])):
                if ($temp['status'] == '1') {
                    $retorno['status'] = 'Processing';
                }

                if ($temp['status'] == '2') {
                    $retorno['status'] = 'Completed';
                }

                if ($temp['status'] == '3') {
                    $retorno['status'] = 'Partial';
                }
                if ($temp['status'] == '6') {
                    $retorno['status'] = 'Partial';
                }
                if ($temp['status'] == '4') {
                    $retorno['status'] = 'Paused';
                }
                if ($temp['status'] == 'Processando'):
                    $retorno['status'] = 'Processing';
                endif;
                if ($temp['status'] == 'Finalizado'):
                    $retorno['status'] = 'Completed';
                endif;
            endif;
            if (isset($temp['quantity'])):
                $retorno['remains'] = $temp['quantity'];
            endif;
            return $retorno;
            
            
        }
    }

    public function services($idapi) {

        $linhaApi = $this->obterApi($idapi);

        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Padrao") {
            return $api->services();
        } else if ($linhaApi['tipoapi'] == "Brasil") {
            null;
        }
    }

    public function balance($idapi) {

        $linhaApi = $this->obterApi($idapi);


        if (!empty($linhaApi['id_Usuario'])):
            $id = $linhaApi['id_Usuario'];
        else:
            $id = 0;
        endif;

        if (!empty($linhaApi['statusParam'])):
            $statusParam = $linhaApi['statusParam'];
        else:
            $statusParam = 0;
        endif;

        if (!empty($linhaApi['saldoParam'])):
            $saldoParam = $linhaApi['saldoParam'];
        else:
            $saldoParam = 0;
        endif;

        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Padrao") {

            $api = new ApiPadrao($linhaApi['link'], $linhaApi['token'], $id, null, $statusParam, $saldoParam);

            $retorno = $api->balance($linhaApi['token'], $saldoParam);
            if (!empty($retorno['saldo']) AND $retorno['saldo'] == true):
                return $retorno['saldo'];
            elseif (!empty($retorno['balance']) AND $retorno['balance'] == true):
                return $retorno['balance'];
            else:
                return false;
            endif;
        }
        else if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Brasil") {
            $api = new ApiBrasil($linhaApi['link'], $linhaApi['token'], $id, $statusParam, $saldoParam);

            $retorno = $api->balance();

            if (!empty($retorno['saldo']) AND $retorno['saldo'] == true):
                return $retorno['saldo'];
            elseif (!empty($retorno['balance']) AND $retorno['balance'] == true):
                return $retorno['balance'];
            else:
                return false;
            endif;
        }
    }

    public function refil($idapi, $idordemapi) { // get balance
        $linhaApi = $this->obterApi($idapi);

        if (!empty($linhaApi['id_Usuario'])):
            $id = $linhaApi['id_Usuario'];
        else:
            $id = 0;
        endif;

        if (!empty($linhaApi['statusParam'])):
            $statusParam = $linhaApi['statusParam'];
        else:
            $statusParam = 0;
        endif;

        if (!empty($linhaApi['saldoParam'])):
            $saldoParam = $linhaApi['saldoParam'];
        else:
            $saldoParam = 0;
        endif;

        if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Padrao") {
            $api_padrao = new ApiPadrao($linhaApi['link'], $linhaApi['token'], $id, null, $statusParam, $saldoParam);
            return $api_padrao->refil($idordemapi);
        } else if (isset($linhaApi['tipoapi']) && $linhaApi['tipoapi'] == "Brasil") {
            $api = new ApiBrasil($linhaApi['link'], $linhaApi['token'], $id, $statusParam, $saldoParam);
            return $api->refil($idordemapi,$linhaApi['refil']);
        }
    }

    public function obterApi($idapi) {
        global $db;
        $res = $db->where('idapi', $idapi)->where('ativo', 1)->getOne("ws_api");
        if ($res):
            return (array) $res;
        endif;
    }

}

?>