<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Clientes
 *
 * @author WEBLAB
 */
class Empresa {

    private $Data;
    private $Empresa;
    private $Error;
    private $Result;

    //Nome da tabela no banco de dados
    const Entity = 'ga_site';

    

    /**
     * <b>Atualizar UsuÃ¡rio:</b> Envelope os dados em uma array atribuitivo e informe o id de um
     * usuÃ¡rio para atualiza-lo no sistema!
     * @param INT $UserId = Id do usuÃ¡rio
     * @param ARRAY $Data = Atribuitivo
     */
    public function ExeUpdate($Empresa, array $Data) {
        $this->Empresa = (int) $Empresa;
        $this->Data = $Data;
        $this->setData();
        $this->checkData();

        if (is_array($this->Data['logoEmpresa'])):
            $readCapa = new Read;
            $readCapa->ExeRead(self::Entity, "WHERE idSite = :post", "post={$this->Empresa}");
            $capa = 'uploads/' . $readCapa->getResult()[0]->logoEmpresa;
            if (file_exists($capa) && !is_dir($capa)):
                unlink($capa);
            endif;

            $uploadCapa = new Upload;
            $uploadCapa->Image($this->Data['logoEmpresa'], 'logo', null, 'logo');
        endif;

        if (isset($uploadCapa) && $uploadCapa->getResult()):
            $this->Data['logoEmpresa'] = $uploadCapa->getResult();
            $this->Update();
        else:
            unset($this->Data['logoEmpresa']);
            $this->Update();
        endif;
    }

    /**
     * <b>Verificar Cadastro:</b> Retorna TRUE se o cadastro ou update for efetuado ou FALSE se nÃ£o.
     * Para verificar erros execute um getError();
     * @return BOOL $Var = True or False
     */
    public function getResult() {
        return $this->Result;
    }

    /**
     * <b>Obter Erro:</b> Retorna um array associativo com um erro e um tipo.
     * @return ARRAY $Error = Array associatico com o erro
     */
    public function getError() {
        return $this->Error;
    }

    /*
     * ***************************************
     * **********  PRIVATE METHODS  **********
     * ***************************************
     */

    //Verifica os dados digitados no formulÃ¡rio
    private function checkData() {
        $Check = new Check;
        $this->checkEmail();
    }

    //Verifica usuÃ¡rio pelo e-mail, Impede cadastro duplicado!
    private function checkEmail() {
        $Where = ( isset($this->Empresa) ? "idSite != {$this->Empresa} AND" : '');

        $readUser = new Read;
        $readUser->ExeRead(self::Entity, "WHERE {$Where} emailSite = :email", "email={$this->Data['emailSite']}");

        if ($readUser->getRowCount()):
            $this->Error = ["O e-email informado ja está cadastrado no sistema! Informe outro e-mail!", WS_ERROR];
            $this->Result = false;
        else:
            $this->Result = true;
        endif;
    }

    //Valida e cria os dados para realizar o cadastro
    private function setData() {
        $Cover = $this->Data['logoEmpresa'];
        unset($this->Data['logoEmpresa']);

        $this->Data['logoEmpresa'] = $Cover;
    }


    //Atualiza UsuÃ¡rio!
    private function Update() {
        $Update = new Update;

        $Update->ExeUpdate(self::Entity, $this->Data, "WHERE idSite = :id", "id={$this->Empresa}");
        if ($Update->getResult()):
            $this->Error = ["O Site <b>{$this->Data['tituloSite']}</b> foi atualizado com sucesso!", WS_ACCEPT];
            $this->Result = true;
        endif;
    }

}
