<?php

class ApiBrasil {

    public $api_url = ''; // API URL
    public $api_key = ''; // Your API key
    public $refil = 4;
    public $tipo = 'REALIZAR_PEDIDO';
    public $id = 0;
    public $statusParam;
    public $saldoParam;

    function __construct($url, $token, $idUsuario = 0, $statusParam = null, $saldoParam = null, $tipo = null) {

        $this->statusParam = $statusParam;
        $this->saldoParam = $saldoParam;
        $this->api_url = $url;
        $this->api_key = $token;
        $this->tipo = $tipo;
        $this->id = $idUsuario;
        if ($this->api_url == 'http://www.painelsocial.com/api.php'):
            $this->refil = 3;
        endif;
    }

    public function order($data) { // add order
        $post = array_merge(array('tipo' => 'REALIZAR_PEDIDO', 'id_usuario' => $this->id, 'api_token' => $this->api_key, 'token' => $this->api_key, 'action' => 1), $data);
        return json_decode($this->connect($post), true);
    }

    public function status($order_id) {

        return json_decode($this->connect(array('tipo' => $this->statusParam, 'id_usuario' => $this->id, 'api_token' => $this->api_key,
                    'token' => $this->api_key,
                    'action' => $this->statusParam,
                    'id_pedido' => $order_id,
                    'id' => $order_id
                )), true);
    }

    public function services() { // get services
        return json_decode($this->connect(array('tipo' => $this->tipo, 'id_usuario' => $this->id, 'api_token' => $this->api_key,
                    'token' => $this->api_key,
                    'action' => 'services',
                )), true);
    }

    public function balance() { // get balance       
        return json_decode($this->connect(array('tipo' => 'SALDO', 'id_usuario' => $this->id, 'api_token' => $this->api_key,
                    'token' => $this->api_key,
                    'action' => $this->saldoParam
                )), true);
    }

    public function refil($order_id, $param = 4) { // get refil
        $this->refil = $param;
        return json_decode($this->connect(array('tipo' => $this->tipo, 'id_usuario' => $this->id, 'api_token' => $this->api_key,
                    'token' => $this->api_key,
                    'action' => $this->refil,
                    'id' => $order_id
                )), true);
    }

    private function connect($post) {

        $_post = array();
        if (is_array($post)) {
            foreach ($post as $name => $value) {
                $_post[] = $name . '=' . urlencode($value);
            }
        }

        $ch = curl_init($this->api_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        if (is_array($post)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, join('&', $_post));
        }
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        $result = curl_exec($ch);
        if (curl_errno($ch) != 0 && empty($result)) {
            $result = false;
        }
        curl_close($ch);

        return $result;
    }

}

?>